/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.mruoc.properties.FileContentLoadException;
import uk.co.mruoc.properties.FileContentLoader;
import uk.co.mruoc.properties.InputStreamConverter;

public class FileSystemFileContentLoader
implements FileContentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemFileContentLoader.class);
    private InputStreamConverter converter = new InputStreamConverter();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String loadContent(String path) {
        LOGGER.info("loading file content from file system path " + path);
        try (FileInputStream stream = new FileInputStream(new File(path));){
            String string = this.converter.toString(stream);
            return string;
        }
        catch (IOException | NullPointerException e) {
            throw new FileContentLoadException(path, e);
        }
    }
}

