/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.template;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.mruoc.template.FileOutputStreamConverter;
import uk.co.mruoc.template.TemplatePopulationException;
import uk.co.mruoc.template.TemplatePopulationParams;
import uk.co.mruoc.template.TemplatePopulator;

public class DefaultTemplatePopulator
implements TemplatePopulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTemplatePopulator.class);
    private final FileOutputStreamConverter fileOutputStreamConverter = new FileOutputStreamConverter();

    @Override
    public void populate(TemplatePopulationParams params) {
        try {
            this.doPopulate(params);
        }
        catch (IOException e) {
            throw new TemplatePopulationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPopulate(TemplatePopulationParams params) throws IOException {
        try (OutputStream outputStream = this.fileOutputStreamConverter.toOutputStream(params.getOutputPath());){
            LOGGER.info("creating template with content " + params.getTemplateContent());
            JtwigTemplate template = JtwigTemplate.inlineTemplate((String)params.getTemplateContent());
            LOGGER.info("creating model with properties " + params.getProperties());
            JtwigModel model = JtwigModel.newModel(this.toMap(params.getProperties()));
            template.render(model, outputStream);
        }
    }

    private Map<String, Object> toMap(Properties properties) {
        return new HashMap<String, Object>((Map<String, Object>)Maps.fromProperties((Properties)properties));
    }
}

