/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.template;

import java.util.Properties;
import uk.co.mruoc.properties.FileContentLoader;
import uk.co.mruoc.properties.FileSystemFileContentLoader;
import uk.co.mruoc.properties.FileSystemPropertyLoader;
import uk.co.mruoc.properties.PropertyLoader;
import uk.co.mruoc.template.FileTemplatePopulationPaths;
import uk.co.mruoc.template.TemplatePopulationParams;

public class FileTemplatePopulationParams
implements TemplatePopulationParams {
    private final String templateContent;
    private final Properties properties;
    private final String outputPath;

    public FileTemplatePopulationParams(FileTemplatePopulationParamsBuilder builder) {
        this.templateContent = builder.templateContent;
        this.properties = builder.properties;
        this.outputPath = builder.outputPath;
    }

    @Override
    public String getTemplateContent() {
        return this.templateContent;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String getOutputPath() {
        return this.outputPath;
    }

    public static class FileTemplatePopulationParamsBuilder {
        private final FileContentLoader contentLoader;
        private final PropertyLoader propertyLoader;
        private String templateContent;
        private Properties properties;
        private String outputPath;

        public FileTemplatePopulationParamsBuilder() {
            this((FileContentLoader)new FileSystemFileContentLoader(), (PropertyLoader)new FileSystemPropertyLoader());
        }

        public FileTemplatePopulationParamsBuilder(FileContentLoader contentLoader, PropertyLoader propertyLoader) {
            this.contentLoader = contentLoader;
            this.propertyLoader = propertyLoader;
        }

        public FileTemplatePopulationParamsBuilder setTemplatePath(String templatePath) {
            this.templateContent = this.contentLoader.loadContent(templatePath);
            return this;
        }

        public FileTemplatePopulationParamsBuilder setPropertiesPath(String propertiesPath) {
            this.properties = this.propertyLoader.load(propertiesPath);
            return this;
        }

        public FileTemplatePopulationParamsBuilder setOutputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public FileTemplatePopulationParamsBuilder setPaths(FileTemplatePopulationPaths paths) {
            this.setTemplatePath(paths.getTemplatePath());
            this.setPropertiesPath(paths.getPropertiesPath());
            this.setOutputPath(paths.getOutputPath());
            return this;
        }

        public FileTemplatePopulationParams build() {
            return new FileTemplatePopulationParams(this);
        }
    }
}

