/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.statements;

import com.github.noconnor.junitperf.statements.TestStatement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class FullStatement
implements TestStatement {
    private List<Method> beforeEach = Collections.emptyList();
    private List<Method> afterEach = Collections.emptyList();
    private final Object testClass;
    private final Method testMethod;
    private final List<Object> args;

    public void runBefores() throws Throwable {
        for (Method m : this.beforeEach) {
            m.setAccessible(true);
            m.invoke(this.testClass, new Object[0]);
        }
    }

    public void evaluate() throws Throwable {
        this.testMethod.setAccessible(true);
        this.testMethod.invoke(this.testClass, this.args.toArray());
    }

    public void runAfters() throws Throwable {
        for (Method m : this.afterEach) {
            m.setAccessible(true);
            m.invoke(this.testClass, new Object[0]);
        }
    }

    public FullStatement(Object testClass, Method testMethod, List<Object> args) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.args = args;
    }

    public List<Method> getBeforeEach() {
        return this.beforeEach;
    }

    public void setBeforeEach(List<Method> beforeEach) {
        this.beforeEach = beforeEach;
    }

    public List<Method> getAfterEach() {
        return this.afterEach;
    }

    public void setAfterEach(List<Method> afterEach) {
        this.afterEach = afterEach;
    }
}

