/*
 * Decompiled with CFR 0.152.
 */
package com.github.noconnor.junitperf.suite;

import com.github.noconnor.junitperf.JUnitPerfReportingConfig;
import com.github.noconnor.junitperf.JUnitPerfTest;
import com.github.noconnor.junitperf.JUnitPerfTestActiveConfig;
import com.github.noconnor.junitperf.JUnitPerfTestRequirement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuiteRegistry {
    private static final Logger log = LoggerFactory.getLogger(SuiteRegistry.class);
    private static final Map<String, SuiteSettings> settingsCache = new HashMap<String, SuiteSettings>();
    private static final Pattern suiteClassPattern = Pattern.compile("\\[suite:([^\\]]*)\\]");

    public static void scanForSuiteDetails(ExtensionContext context) {
        String rootUniqueId = SuiteRegistry.getRootId(context);
        Class<?> clazz = SuiteRegistry.getTopLevelSuiteClass(rootUniqueId);
        if (Objects.isNull(clazz) || settingsCache.containsKey(rootUniqueId)) {
            return;
        }
        JUnitPerfTest testSpec = clazz.getAnnotation(JUnitPerfTest.class);
        JUnitPerfTestRequirement requirements = clazz.getAnnotation(JUnitPerfTestRequirement.class);
        JUnitPerfReportingConfig reportingConfig = Arrays.stream(clazz.getFields()).filter(f -> f.isAnnotationPresent(JUnitPerfTestActiveConfig.class)).map(f -> {
            SuiteRegistry.warnIfNonStatic(f);
            return SuiteRegistry.getFieldValue(f);
        }).filter(Objects::nonNull).findFirst().orElse(null);
        SuiteSettings suiteSettings = SuiteSettings.builder().perfTestSpec(testSpec).requirements(requirements).reportingConfig(reportingConfig).build();
        settingsCache.put(rootUniqueId, suiteSettings);
    }

    public static void clearRegistry() {
        settingsCache.clear();
    }

    public static JUnitPerfReportingConfig getReportingConfig(ExtensionContext context) {
        SuiteSettings s = settingsCache.get(SuiteRegistry.getRootId(context));
        return Objects.nonNull(s) ? s.getReportingConfig() : null;
    }

    public static JUnitPerfTest getPerfTestData(ExtensionContext context) {
        SuiteSettings s = settingsCache.get(SuiteRegistry.getRootId(context));
        return Objects.nonNull(s) ? s.getPerfTestSpec() : null;
    }

    public static JUnitPerfTestRequirement getPerfRequirements(ExtensionContext context) {
        SuiteSettings s = settingsCache.get(SuiteRegistry.getRootId(context));
        return Objects.nonNull(s) ? s.getRequirements() : null;
    }

    private static String getRootId(ExtensionContext context) {
        if (Objects.nonNull(context) && Objects.nonNull(context.getRoot())) {
            return context.getRoot().getUniqueId();
        }
        return "";
    }

    private static Class<?> getTopLevelSuiteClass(String rootUniqueId) {
        Matcher m = suiteClassPattern.matcher(rootUniqueId);
        if (m.find()) {
            try {
                return Class.forName(m.group(1));
            }
            catch (ClassNotFoundException e) {
                log.warn("Suite class not found: {}", (Object)rootUniqueId);
            }
        }
        return null;
    }

    private static JUnitPerfReportingConfig getFieldValue(Field f) {
        try {
            f.setAccessible(true);
            return (JUnitPerfReportingConfig)f.get(null);
        }
        catch (Exception e) {
            log.error("Unable to access JUnitPerfReportingConfig, make sure config is a static variable", (Throwable)e);
            return null;
        }
    }

    private static void warnIfNonStatic(Field f) {
        if (!Modifier.isStatic(f.getModifiers())) {
            log.warn("JUnitPerfReportingConfig must be static for test suites");
        }
    }

    private static final class SuiteSettings {
        private final JUnitPerfTest perfTestSpec;
        private final JUnitPerfTestRequirement requirements;
        private final JUnitPerfReportingConfig reportingConfig;

        SuiteSettings(JUnitPerfTest perfTestSpec, JUnitPerfTestRequirement requirements, JUnitPerfReportingConfig reportingConfig) {
            this.perfTestSpec = perfTestSpec;
            this.requirements = requirements;
            this.reportingConfig = reportingConfig;
        }

        public static SuiteSettingsBuilder builder() {
            return new SuiteSettingsBuilder();
        }

        public JUnitPerfTest getPerfTestSpec() {
            return this.perfTestSpec;
        }

        public JUnitPerfTestRequirement getRequirements() {
            return this.requirements;
        }

        public JUnitPerfReportingConfig getReportingConfig() {
            return this.reportingConfig;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuiteSettings)) {
                return false;
            }
            SuiteSettings other = (SuiteSettings)o;
            JUnitPerfTest this$perfTestSpec = this.getPerfTestSpec();
            JUnitPerfTest other$perfTestSpec = other.getPerfTestSpec();
            if (this$perfTestSpec == null ? other$perfTestSpec != null : !this$perfTestSpec.equals(other$perfTestSpec)) {
                return false;
            }
            JUnitPerfTestRequirement this$requirements = this.getRequirements();
            JUnitPerfTestRequirement other$requirements = other.getRequirements();
            if (this$requirements == null ? other$requirements != null : !this$requirements.equals(other$requirements)) {
                return false;
            }
            JUnitPerfReportingConfig this$reportingConfig = this.getReportingConfig();
            JUnitPerfReportingConfig other$reportingConfig = other.getReportingConfig();
            return !(this$reportingConfig == null ? other$reportingConfig != null : !((Object)this$reportingConfig).equals(other$reportingConfig));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JUnitPerfTest $perfTestSpec = this.getPerfTestSpec();
            result = result * 59 + ($perfTestSpec == null ? 43 : $perfTestSpec.hashCode());
            JUnitPerfTestRequirement $requirements = this.getRequirements();
            result = result * 59 + ($requirements == null ? 43 : $requirements.hashCode());
            JUnitPerfReportingConfig $reportingConfig = this.getReportingConfig();
            result = result * 59 + ($reportingConfig == null ? 43 : ((Object)$reportingConfig).hashCode());
            return result;
        }

        public String toString() {
            return "SuiteRegistry.SuiteSettings(perfTestSpec=" + this.getPerfTestSpec() + ", requirements=" + this.getRequirements() + ", reportingConfig=" + this.getReportingConfig() + ")";
        }

        public static class SuiteSettingsBuilder {
            private JUnitPerfTest perfTestSpec;
            private JUnitPerfTestRequirement requirements;
            private JUnitPerfReportingConfig reportingConfig;

            SuiteSettingsBuilder() {
            }

            public SuiteSettingsBuilder perfTestSpec(JUnitPerfTest perfTestSpec) {
                this.perfTestSpec = perfTestSpec;
                return this;
            }

            public SuiteSettingsBuilder requirements(JUnitPerfTestRequirement requirements) {
                this.requirements = requirements;
                return this;
            }

            public SuiteSettingsBuilder reportingConfig(JUnitPerfReportingConfig reportingConfig) {
                this.reportingConfig = reportingConfig;
                return this;
            }

            public SuiteSettings build() {
                return new SuiteSettings(this.perfTestSpec, this.requirements, this.reportingConfig);
            }

            public String toString() {
                return "SuiteRegistry.SuiteSettings.SuiteSettingsBuilder(perfTestSpec=" + this.perfTestSpec + ", requirements=" + this.requirements + ", reportingConfig=" + this.reportingConfig + ")";
            }
        }
    }
}

