/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar;

public class ProtocVersion {
    public static final ProtocVersion PROTOC_VERSION = new ProtocVersion(null, null, "3.5.1");
    public final String mGroup;
    public final String mArtifact;
    public final String mVersion;

    public static ProtocVersion getVersion(String spec) {
        if (!spec.startsWith("-v")) {
            return null;
        }
        ProtocVersion version = null;
        String[] as = spec.split(":");
        version = as.length == 4 && as[0].equals("-v") ? new ProtocVersion(as[1], as[2], as[3]) : new ProtocVersion(null, null, spec.substring(2));
        if (version.mVersion.length() == 3) {
            String dotVersion = version.mVersion.charAt(0) + "." + version.mVersion.charAt(1) + "." + version.mVersion.charAt(2);
            version = new ProtocVersion(version.mGroup, version.mArtifact, dotVersion);
        }
        return version;
    }

    public ProtocVersion(String group, String artifact, String version) {
        this.mGroup = group;
        this.mArtifact = artifact;
        this.mVersion = version;
    }

    public String toString() {
        if (this.mArtifact == null) {
            return this.mVersion;
        }
        return this.mGroup + ":" + this.mArtifact + ":" + this.mVersion;
    }
}

