/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import oshi.hardware.common.AbstractBaseboard;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WindowsBaseboard
extends AbstractBaseboard {
    private static final long serialVersionUID = 1L;

    WindowsBaseboard() {
        this.init();
    }

    private void init() {
        WbemcliUtil.WmiQuery baseboardQuery = new WbemcliUtil.WmiQuery("Win32_BaseBoard", BaseboardProperty.class);
        WbemcliUtil.WmiResult win32BaseBoard = WmiQueryHandler.createInstance().queryWMI(baseboardQuery);
        if (win32BaseBoard.getResultCount() > 0) {
            this.setManufacturer(WmiUtil.getString(win32BaseBoard, BaseboardProperty.MANUFACTURER, 0));
            this.setModel(WmiUtil.getString(win32BaseBoard, BaseboardProperty.MODEL, 0));
            this.setVersion(WmiUtil.getString(win32BaseBoard, BaseboardProperty.VERSION, 0));
            this.setSerialNumber(WmiUtil.getString(win32BaseBoard, BaseboardProperty.SERIALNUMBER, 0));
        }
    }

    static enum BaseboardProperty {
        MANUFACTURER,
        MODEL,
        VERSION,
        SERIALNUMBER;

    }
}

