/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Cfgmgr32;
import com.sun.jna.platform.win32.Cfgmgr32Util;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

public class WindowsUsbDevice
extends AbstractUsbDevice {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsUsbDevice.class);
    private static List<String> controllerDeviceIds = null;
    private static final String PNPENTITY_BASE_CLASS = "Win32_PnPEntity";
    private static final WbemcliUtil.WmiQuery<PnPEntityProperty> PNPENTITY_QUERY = new WbemcliUtil.WmiQuery(null, PnPEntityProperty.class);
    private static final String DISKDRIVE_BASE_CLASS = "Win32_DiskDrive";
    private static final WbemcliUtil.WmiQuery<DiskDriveProperty> DISKDRIVE_QUERY = new WbemcliUtil.WmiQuery(null, DiskDriveProperty.class);
    private static final Pattern VENDOR_PRODUCT_ID = Pattern.compile(".*(?:VID|VEN)_(\\p{XDigit}{4})&(?:PID|DEV)_(\\p{XDigit}{4}).*");
    private static Map<String, WindowsUsbDevice> usbDeviceCache = new HashMap<String, WindowsUsbDevice>();

    public WindowsUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = WindowsUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[deviceList.size()]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(new WindowsUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), new UsbDevice[0]));
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static UsbDevice[] getUsbDevices() {
        HashMap<String, List<String>> deviceTreeMap = new HashMap<String, List<String>>();
        HashSet<String> devicesSeen = new HashSet<String>();
        ArrayList<WindowsUsbDevice> controllerDevices = new ArrayList<WindowsUsbDevice>();
        WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();
        List<String> controllerDeviceIdList = WindowsUsbDevice.getControllerDeviceIdList(wmiQueryHandler);
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice.putChildrenInDeviceTree(controllerDeviceId, 0, deviceTreeMap, devicesSeen);
        }
        WindowsUsbDevice.updateDeviceCache(devicesSeen, wmiQueryHandler);
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(controllerDeviceId, "0000", "0000", deviceTreeMap);
            if (deviceAndChildren == null) continue;
            controllerDevices.add(deviceAndChildren);
        }
        return controllerDevices.toArray(new WindowsUsbDevice[controllerDevices.size()]);
    }

    private static void updateDeviceCache(Set<String> devicesSeen, WmiQueryHandler wmiQueryHandler) {
        HashSet<String> devicesToRemove = new HashSet<String>(usbDeviceCache.keySet());
        devicesToRemove.removeAll(devicesSeen);
        for (String deviceID : devicesToRemove) {
            usbDeviceCache.remove(deviceID);
            LOG.debug("Removing {} from USB device cache.", (Object)deviceID);
        }
        HashSet<String> devicesToAdd = new HashSet<String>(devicesSeen);
        devicesToAdd.removeAll(usbDeviceCache.keySet());
        if (!devicesToAdd.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String deviceID : devicesToAdd) {
                if (first) {
                    sb.append(" WHERE (PnPDeviceID=\"");
                    first = false;
                } else {
                    sb.append(" OR (PnPDeviceID=\"");
                }
                sb.append(deviceID).append("\")");
            }
            String whereClause = sb.toString();
            PNPENTITY_QUERY.setWmiClassName(PNPENTITY_BASE_CLASS + whereClause);
            WbemcliUtil.WmiResult<PnPEntityProperty> pnpEntity = wmiQueryHandler.queryWMI(PNPENTITY_QUERY);
            for (int i = 0; i < pnpEntity.getResultCount(); ++i) {
                String pnpDeviceID = WmiUtil.getString(pnpEntity, PnPEntityProperty.PNPDEVICEID, i);
                String name = WmiUtil.getString(pnpEntity, PnPEntityProperty.NAME, i);
                String vendor = WmiUtil.getString(pnpEntity, PnPEntityProperty.MANUFACTURER, i);
                WindowsUsbDevice device = new WindowsUsbDevice(name, vendor, null, null, "", new WindowsUsbDevice[0]);
                usbDeviceCache.put(pnpDeviceID, device);
                LOG.debug("Adding {} to USB device cache.", (Object)pnpDeviceID);
            }
            DISKDRIVE_QUERY.setWmiClassName(DISKDRIVE_BASE_CLASS + whereClause);
            WbemcliUtil.WmiResult<DiskDriveProperty> serialNumber = wmiQueryHandler.queryWMI(DISKDRIVE_QUERY);
            for (int i = 0; i < serialNumber.getResultCount(); ++i) {
                String pnpDeviceID = WmiUtil.getString(serialNumber, DiskDriveProperty.PNPDEVICEID, i);
                if (!usbDeviceCache.containsKey(pnpDeviceID)) continue;
                WindowsUsbDevice device = usbDeviceCache.get(pnpDeviceID);
                device.serialNumber = ParseUtil.hexStringToString(WmiUtil.getString(serialNumber, DiskDriveProperty.SERIALNUMBER, i));
            }
        }
    }

    private static void putChildrenInDeviceTree(String deviceId, int deviceInstance, Map<String, List<String>> deviceTreeMap, Set<String> devicesSeen) {
        IntByReference child;
        devicesSeen.add(deviceId);
        int devInst = deviceInstance;
        if (devInst == 0) {
            IntByReference pdnDevInst = new IntByReference();
            Cfgmgr32.INSTANCE.CM_Locate_DevNode(pdnDevInst, deviceId, 0);
            devInst = pdnDevInst.getValue();
        }
        if (0 == Cfgmgr32.INSTANCE.CM_Get_Child(child = new IntByReference(), devInst, 0)) {
            ArrayList<String> childList = new ArrayList<String>();
            String childId = Cfgmgr32Util.CM_Get_Device_ID((int)child.getValue());
            childList.add(childId);
            deviceTreeMap.put(deviceId, childList);
            WindowsUsbDevice.putChildrenInDeviceTree(childId, child.getValue(), deviceTreeMap, devicesSeen);
            IntByReference sibling = new IntByReference();
            while (0 == Cfgmgr32.INSTANCE.CM_Get_Sibling(sibling, child.getValue(), 0)) {
                String siblingId = Cfgmgr32Util.CM_Get_Device_ID((int)sibling.getValue());
                deviceTreeMap.get(deviceId).add(siblingId);
                WindowsUsbDevice.putChildrenInDeviceTree(siblingId, sibling.getValue(), deviceTreeMap, devicesSeen);
                child = sibling;
            }
        }
    }

    private static WindowsUsbDevice getDeviceAndChildren(String hubDeviceId, String vid, String pid, Map<String, List<String>> deviceTreeMap) {
        String vendorId = vid;
        String productId = pid;
        Matcher m = VENDOR_PRODUCT_ID.matcher(hubDeviceId);
        if (m.matches()) {
            vendorId = m.group(1).toLowerCase();
            productId = m.group(2).toLowerCase();
        }
        List pnpDeviceIds = MapUtil.getOrDefault(deviceTreeMap, hubDeviceId, new ArrayList());
        ArrayList<WindowsUsbDevice> usbDevices = new ArrayList<WindowsUsbDevice>();
        for (String pnpDeviceId : pnpDeviceIds) {
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(pnpDeviceId, vendorId, productId, deviceTreeMap);
            if (deviceAndChildren == null) continue;
            usbDevices.add(deviceAndChildren);
        }
        Collections.sort(usbDevices);
        if (usbDeviceCache.containsKey(hubDeviceId)) {
            WindowsUsbDevice device = usbDeviceCache.get(hubDeviceId);
            if (device.name.isEmpty()) {
                device.name = vendorId + ":" + productId;
            }
            device.vendorId = vendorId;
            device.productId = productId;
            device.connectedDevices = usbDevices.toArray(new WindowsUsbDevice[usbDevices.size()]);
            return device;
        }
        return null;
    }

    private static List<String> getControllerDeviceIdList(WmiQueryHandler wmiQueryHandler) {
        if (controllerDeviceIds == null) {
            controllerDeviceIds = new ArrayList<String>();
            WbemcliUtil.WmiQuery usbControllerQuery = new WbemcliUtil.WmiQuery("Win32_USBController", USBControllerProperty.class);
            WbemcliUtil.WmiResult usbController = wmiQueryHandler.queryWMI(usbControllerQuery);
            for (int i = 0; i < usbController.getResultCount(); ++i) {
                controllerDeviceIds.add(WmiUtil.getString(usbController, USBControllerProperty.PNPDEVICEID, i));
            }
        }
        return controllerDeviceIds;
    }

    static enum DiskDriveProperty {
        PNPDEVICEID,
        SERIALNUMBER;

    }

    static enum PnPEntityProperty {
        NAME,
        MANUFACTURER,
        PNPDEVICEID;

    }

    static enum USBControllerProperty {
        PNPDEVICEID;

    }
}

