/*
 * Decompiled with CFR 0.152.
 */
package oshi.util;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OperatingSystem;

public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static final Map<String, String> vmMacAddressOUI = new HashMap<String, String>();
    private static final String[] vmModelArray;

    private Util() {
    }

    public static void sleep(long ms) {
        try {
            LOG.trace("Sleeping for {} ms", (Object)ms);
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while sleeping for {} ms: {}", (Object)ms, (Object)e);
        }
    }

    public static void sleepAfter(long startTime, long ms) {
        long now = System.currentTimeMillis();
        long until = startTime + ms;
        LOG.trace("Sleeping until {}", (Object)until);
        if (now < until) {
            Util.sleep(until - now);
        }
    }

    public static String getComputerIdentifier() {
        SystemInfo systemInfo = new SystemInfo();
        OperatingSystem operatingSystem = systemInfo.getOperatingSystem();
        HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
        CentralProcessor centralProcessor = hardwareAbstractionLayer.getProcessor();
        ComputerSystem computerSystem = hardwareAbstractionLayer.getComputerSystem();
        String vendor = operatingSystem.getManufacturer();
        String processorSerialNumber = computerSystem.getSerialNumber();
        String processorIdentifier = centralProcessor.getIdentifier();
        int processors = centralProcessor.getLogicalProcessorCount();
        String delimiter = "-";
        return String.format("%08x", vendor.hashCode()) + delimiter + String.format("%08x", processorSerialNumber.hashCode()) + delimiter + String.format("%08x", processorIdentifier.hashCode()) + delimiter + processors;
    }

    public static String identifyVM() {
        NetworkIF[] nifs;
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hw = si.getHardware();
        for (NetworkIF nif : nifs = hw.getNetworkIFs()) {
            String mac = nif.getMacaddr().substring(0, 8).toUpperCase();
            if (!vmMacAddressOUI.containsKey(mac)) continue;
            return vmMacAddressOUI.get(mac);
        }
        String model = hw.getComputerSystem().getModel();
        for (String vm : vmModelArray) {
            if (!model.contains(vm)) continue;
            return vm;
        }
        String manufacturer = hw.getComputerSystem().getManufacturer();
        if ("Microsoft Corporation".equals(manufacturer) && "Virtual Machine".equals(model)) {
            return "Microsoft Hyper-V";
        }
        return "";
    }

    public static boolean wildcardMatch(String text, String pattern) {
        if (pattern.length() > 0 && pattern.charAt(0) == '^') {
            return !Util.wildcardMatch(text, pattern.substring(1));
        }
        return text.matches(pattern.replace("?", ".?").replace("*", ".*?"));
    }

    static {
        vmMacAddressOUI.put("00:50:56", "VMware ESX 3");
        vmMacAddressOUI.put("00:0C:29", "VMware ESX 3");
        vmMacAddressOUI.put("00:05:69", "VMware ESX 3");
        vmMacAddressOUI.put("00:03:FF", "Microsoft Hyper-V");
        vmMacAddressOUI.put("00:1C:42", "Parallels Desktop");
        vmMacAddressOUI.put("00:0F:4B", "Virtual Iron 4");
        vmMacAddressOUI.put("00:16:3E", "Xen or Oracle VM");
        vmMacAddressOUI.put("08:00:27", "VirtualBox");
        vmModelArray = new String[]{"Linux KVM", "Linux lguest", "OpenVZ", "Qemu", "Microsoft Virtual PC", "VMWare", "linux-vserver", "Xen", "FreeBSD Jail", "VirtualBox", "Parallels", "Linux Containers", "LXC"};
    }
}

