/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverExpectation;
import com.github.restdriver.clientdriver.ClientDriverListener;
import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.exception.ClientDriverInternalException;
import com.github.restdriver.clientdriver.exception.ClientDriverSetupException;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientDriver.class);
    protected Server jettyServer;
    private ServerConnector jettyServerConnector;
    private int port = -1;
    private List<ClientDriverListener> listeners = new ArrayList<ClientDriverListener>();
    protected ClientDriverJettyHandler handler;

    public ClientDriver(ClientDriverJettyHandler handler) {
        this(handler, 0);
    }

    public ClientDriver(ClientDriverJettyHandler handler, int port) {
        this.handler = handler;
        this.jettyServer = this.createAndStartJetty(port);
    }

    protected ClientDriver() {
    }

    protected Server createAndStartJetty(int port) {
        Server jetty = new Server();
        jetty.setHandler((Handler)this.handler);
        ServerConnector connector = this.createConnector(jetty, port);
        jetty.addConnector((Connector)connector);
        try {
            jetty.start();
        }
        catch (Exception e) {
            throw new ClientDriverSetupException("Error starting jetty on port " + port, e);
        }
        this.port = connector.getLocalPort();
        this.jettyServerConnector = connector;
        return jetty;
    }

    protected SslContextFactory getSslContextFactory() {
        return null;
    }

    protected ServerConnector createConnector(Server jetty, int port) {
        ServerConnector connector = new ServerConnector(jetty, this.getSslContextFactory());
        connector.setHost(null);
        connector.setPort(port);
        return connector;
    }

    protected void replaceConnector(ServerConnector newConnector, Server jetty) {
        this.jettyServerConnector.shutdown();
        try {
            this.jettyServerConnector.stop();
        }
        catch (Exception e) {
            throw new ClientDriverInternalException("Error shutting down jetty connector during replacement", e);
        }
        jetty.removeConnector((Connector)this.jettyServerConnector);
        jetty.addConnector((Connector)newConnector);
        try {
            newConnector.start();
        }
        catch (Exception e) {
            throw new ClientDriverInternalException("Error starting new jetty connector during replacement", e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getBaseUrl() {
        return "http://localhost:" + this.port;
    }

    public void verify() {
        LOGGER.info("Beginning verification");
        this.handler.checkForUnexpectedRequests();
        this.handler.checkForUnmatchedExpectations();
    }

    public void noFailFastOnUnexpectedRequest() {
        this.handler.noFailFastOnUnexpectedRequest();
    }

    public void reset() {
        this.handler.reset();
    }

    public void shutdownQuietly() {
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            throw new ClientDriverInternalException("Error shutting down jetty", e);
        }
        finally {
            this.completed();
        }
    }

    public void shutdown() {
        this.shutdownQuietly();
        this.verify();
    }

    public ClientDriverExpectation addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        return this.handler.addExpectation(request, response);
    }

    void addListener(ClientDriverListener listener) {
        this.listeners.add(listener);
    }

    private void completed() {
        for (ClientDriverListener listener : this.listeners) {
            listener.hasCompleted();
        }
    }

    public void verify(ClientDriverRequest clientDriverRequest, int times) {
        this.handler.verify(clientDriverRequest, times);
    }
}

