/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.capture.BodyCapture;
import com.github.restdriver.matchers.MatchesRegex;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

public final class ClientDriverRequest {
    private static final String CONTENT_TYPE = "Content-Type";
    private final Matcher<? extends String> path;
    private final Multimap<String, Matcher<? extends String>> params;
    private final Map<String, Matcher<? extends String>> headers;
    private final Set<String> excludedHeaders;
    private Method method;
    private Matcher<? extends String> bodyContentMatcher;
    private Matcher<? extends String> bodyContentType;
    private boolean anyParams;
    private BodyCapture<?> bodyCapture;

    public ClientDriverRequest(Matcher<? extends String> path) {
        this.path = path;
        this.method = Method.GET;
        this.params = HashMultimap.create();
        this.headers = new HashMap<String, Matcher<? extends String>>();
        this.excludedHeaders = new HashSet<String>();
        this.anyParams = false;
    }

    public ClientDriverRequest(String path) {
        this((Matcher<? extends String>)new IsEqual((Object)path));
    }

    public ClientDriverRequest(Pattern path) {
        this((Matcher<? extends String>)new MatchesRegex(path));
    }

    public Matcher<? extends String> getPath() {
        return this.path;
    }

    public ClientDriverRequest withMethod(Method withMethod) {
        this.method = withMethod;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public ClientDriverRequest withAnyParams() {
        this.anyParams = true;
        return this;
    }

    public ClientDriverRequest withParam(String key, String value) {
        this.params.put((Object)key, (Object)new IsEqual((Object)value));
        return this;
    }

    public ClientDriverRequest withParam(String key, int value) {
        return this.withParam(key, String.valueOf(value));
    }

    public ClientDriverRequest withParam(String key, long value) {
        return this.withParam(key, String.valueOf(value));
    }

    public ClientDriverRequest withParam(String key, boolean value) {
        return this.withParam(key, String.valueOf(value));
    }

    public ClientDriverRequest withParam(String key, Object value) {
        return this.withParam(key, value.toString());
    }

    public ClientDriverRequest withParam(String key, Pattern value) {
        this.params.put((Object)key, (Object)new MatchesRegex(value));
        return this;
    }

    public ClientDriverRequest withParam(String key, Matcher<? extends String> value) {
        this.params.put((Object)key, value);
        return this;
    }

    public ClientDriverRequest withParams(Map<String, Object> newParams) {
        for (Map.Entry<String, Object> entry : newParams.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Pattern) {
                this.params.put((Object)key, (Object)new MatchesRegex((Pattern)value));
                continue;
            }
            this.params.put((Object)key, (Object)new IsEqual((Object)value.toString()));
        }
        return this;
    }

    Map<String, Collection<Matcher<? extends String>>> getParams() {
        return this.params.asMap();
    }

    boolean getAnyParams() {
        return this.anyParams;
    }

    public String toString() {
        String paramsJoined = Joiner.on((String)",").withKeyValueSeparator("=").join(this.params.asMap());
        String headersJoined = Joiner.on((String)",").withKeyValueSeparator(": ").join(this.headers);
        String excludedHeadersJoined = Joiner.on((String)",").join(this.excludedHeaders);
        return "ClientDriverRequest: " + this.method + " " + this.path.toString() + "; " + "ANY PARAMS: " + this.anyParams + "; " + "PARAMS: [" + paramsJoined + "]; " + "HEADERS: [" + headersJoined + "]; " + "NOT HEADERS: [" + excludedHeadersJoined + "]; " + "CONTENT TYPE " + this.bodyContentType + "; " + "BODY " + this.bodyContentMatcher + ";";
    }

    public Matcher<? extends String> getBodyContentMatcher() {
        return this.bodyContentMatcher;
    }

    public Matcher<? extends String> getBodyContentType() {
        return this.bodyContentType;
    }

    public ClientDriverRequest withBody(String withBodyContent, String withContentType) {
        this.bodyContentMatcher = new IsEqual((Object)withBodyContent);
        this.bodyContentType = new IsEqual((Object)withContentType);
        return this;
    }

    public ClientDriverRequest withBody(String withBodyContent, Pattern contentType) {
        this.bodyContentMatcher = new IsEqual((Object)withBodyContent);
        this.bodyContentType = new MatchesRegex(contentType);
        return this;
    }

    public ClientDriverRequest withBody(Pattern withBodyContent, String contentType) {
        this.bodyContentMatcher = new MatchesRegex(withBodyContent);
        this.bodyContentType = new IsEqual((Object)contentType);
        return this;
    }

    public ClientDriverRequest withBody(Pattern withBodyContent, Pattern contentType) {
        this.bodyContentMatcher = new MatchesRegex(withBodyContent);
        this.bodyContentType = new MatchesRegex(contentType);
        return this;
    }

    public ClientDriverRequest withBody(Matcher<? extends String> bodyContentMatcher, String contentType) {
        this.bodyContentMatcher = bodyContentMatcher;
        this.bodyContentType = new IsEqual((Object)contentType);
        return this;
    }

    public ClientDriverRequest capturingBodyIn(BodyCapture<?> bodyCapture) {
        this.bodyCapture = bodyCapture;
        return this;
    }

    public BodyCapture<?> getBodyCapture() {
        return this.bodyCapture;
    }

    public ClientDriverRequest withHeader(String withHeaderName, Matcher<? extends String> headerValueMatcher) {
        if (CONTENT_TYPE.equalsIgnoreCase(withHeaderName)) {
            this.bodyContentType = headerValueMatcher;
        } else {
            this.headers.put(withHeaderName.toLowerCase(), headerValueMatcher);
        }
        return this;
    }

    public ClientDriverRequest withHeader(String withHeaderName, String withHeaderValue) {
        return this.withHeader(withHeaderName, (Matcher<? extends String>)new IsEqual((Object)withHeaderValue));
    }

    public ClientDriverRequest withoutHeader(String withoutHeaderName) {
        this.excludedHeaders.add(withoutHeaderName);
        return this;
    }

    public ClientDriverRequest withHeader(String withHeaderName, Pattern withHeaderValue) {
        return this.withHeader(withHeaderName, (Matcher<? extends String>)new MatchesRegex(withHeaderValue));
    }

    public ClientDriverRequest withHeaders(Map<String, Object> headers) {
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            Object headerValue = entry.getValue();
            if (headerValue instanceof Pattern) {
                this.withHeader(headerName, (Matcher<? extends String>)new MatchesRegex((Pattern)headerValue));
                continue;
            }
            this.withHeader(headerName, (Matcher<? extends String>)new IsEqual((Object)headerValue.toString()));
        }
        return this;
    }

    public ClientDriverRequest withBasicAuth(String username, String password) {
        this.headers.put("Authorization", (Matcher<? extends String>)new IsEqual((Object)("Basic " + ClientDriverRequest.base64(username + ":" + password))));
        return this;
    }

    public Map<String, Matcher<? extends String>> getHeaders() {
        return this.headers;
    }

    public Set<String> getExcludedHeaders() {
        return this.excludedHeaders;
    }

    private static String base64(String content) {
        return new String(Base64.encodeBase64((byte[])content.getBytes()));
    }

    public static final class Method {
        public static Method GET = new Method("GET");
        public static Method POST = new Method("POST");
        public static Method PUT = new Method("PUT");
        public static Method DELETE = new Method("DELETE");
        public static Method OPTIONS = new Method("OPTIONS");
        public static Method HEAD = new Method("HEAD");
        public static Method TRACE = new Method("TRACE");
        private String value;

        private Method(String value) {
            this.value = value.toUpperCase();
        }

        public static Method custom(String value) {
            return new Method(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Method method = (Method)o;
            return !(this.value != null ? !this.value.equals(method.value) : method.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return this.value;
        }
    }
}

