/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverFactory;
import com.github.restdriver.clientdriver.DefaultRequestMatcher;
import com.github.restdriver.clientdriver.SecureClientDriver;
import com.github.restdriver.clientdriver.jetty.DefaultClientDriverJettyHandler;
import java.security.KeyStore;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureClientDriverFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientDriverFactory.class);
    private int port = 0;
    private String password;
    private String certAlias;
    private KeyStore keyStore;

    public SecureClientDriver createClientDriver(KeyStore keyStore, String password, String certAlias) {
        this.password = password;
        this.certAlias = certAlias;
        this.keyStore = keyStore;
        return this.build();
    }

    public SecureClientDriver createClientDriver(int port, KeyStore keyStore, String password, String certAlias) {
        this.port = port;
        this.password = password;
        this.certAlias = certAlias;
        this.keyStore = keyStore;
        return this.build();
    }

    public SecureClientDriverFactory port(int port) {
        this.port = port;
        return this;
    }

    public SecureClientDriverFactory password(String password) {
        this.password = password;
        return this;
    }

    public SecureClientDriverFactory certAlias(String certAlias) {
        this.certAlias = certAlias;
        return this;
    }

    public SecureClientDriverFactory keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public SecureClientDriver build() {
        Validate.notEmpty((String)this.certAlias, (String)"Certificate alias is not set.");
        Validate.notEmpty((String)this.password, (String)"Password not set.");
        Validate.notNull((Object)this.keyStore, (String)"Key store is not set.");
        SecureClientDriver clientDriver = new SecureClientDriver(new DefaultClientDriverJettyHandler(new DefaultRequestMatcher()), this.port, this.keyStore, this.password, this.certAlias);
        LOGGER.debug("ClientDriver created at '" + clientDriver.getBaseUrl() + "'.");
        return clientDriver;
    }
}

