/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver.exception;

import com.github.restdriver.clientdriver.ClientDriverExpectation;
import com.github.restdriver.clientdriver.HttpRealRequest;
import com.google.common.base.Preconditions;
import java.util.List;

public final class ClientDriverFailedExpectationException
extends RuntimeException {
    private static final long serialVersionUID = -2270688849375416363L;
    private static final String EXPECTATION_MESSAGE_TEMPLATE = "%s%n  %s -> %s";

    public ClientDriverFailedExpectationException(List<HttpRealRequest> unexpectedRequests, List<ClientDriverExpectation> expectations) {
        super(ClientDriverFailedExpectationException.createUnexpectedRequestsMessage(unexpectedRequests, expectations));
    }

    public ClientDriverFailedExpectationException(List<ClientDriverExpectation> failedExpectations) {
        super(ClientDriverFailedExpectationException.createFailedExpectationsMessage(failedExpectations));
    }

    private static String createUnexpectedRequestsMessage(List<HttpRealRequest> unexpectedRequests, List<ClientDriverExpectation> expectations) {
        Preconditions.checkArgument((unexpectedRequests != null && !unexpectedRequests.isEmpty() ? 1 : 0) != 0, (Object)"unexpectedRequests cannot be empty");
        String message = String.format("%d unexpected request(s):", unexpectedRequests.size());
        for (HttpRealRequest unexpectedRequest : unexpectedRequests) {
            message = String.format("%s%n  %s", message, unexpectedRequest);
        }
        if (expectations != null && !expectations.isEmpty()) {
            message = String.format("%s%n%n%d expectation(s):", message, expectations.size());
            message = ClientDriverFailedExpectationException.addExpectationsMessages(expectations, message);
        }
        return message;
    }

    private static String createFailedExpectationsMessage(List<ClientDriverExpectation> failedExpectations) {
        Preconditions.checkArgument((failedExpectations != null && !failedExpectations.isEmpty() ? 1 : 0) != 0, (Object)"failedExpectations cannot be empty");
        String message = String.format("%d unmatched expectation(s):", failedExpectations.size());
        return ClientDriverFailedExpectationException.addExpectationsMessages(failedExpectations, message);
    }

    private static String addExpectationsMessages(List<ClientDriverExpectation> expectations, String message) {
        for (ClientDriverExpectation expectation : expectations) {
            message = String.format(EXPECTATION_MESSAGE_TEMPLATE, message, expectation.getStatusString(), expectation.getPair().getRequest());
        }
        return message;
    }
}

