/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.matchers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.restdriver.exception.RuntimeAssertionFailure;
import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HasJsonWhich
extends TypeSafeMatcher<String> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final Matcher<JsonNode> matcher;

    public HasJsonWhich(Matcher<JsonNode> matcher) {
        this.matcher = matcher;
    }

    public void describeTo(Description description) {
        this.matcher.describeTo(description);
    }

    protected void describeMismatchSafely(String item, Description mismatchDescription) {
        JsonNode node = HasJsonWhich.createNode(item);
        this.matcher.describeMismatch((Object)node, mismatchDescription);
    }

    protected boolean matchesSafely(String item) {
        return this.matcher.matches((Object)HasJsonWhich.createNode(item));
    }

    private static JsonNode createNode(String item) {
        try {
            return MAPPER.readTree(item);
        }
        catch (IOException e) {
            throw new RuntimeAssertionFailure("Failed to create JsonNode", e);
        }
    }
}

