/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.matchers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class WithValueAt
extends TypeSafeMatcher<JsonNode> {
    private final int position;
    private final Matcher<?> matcher;

    public WithValueAt(int position, Matcher<?> matcher) {
        this.position = position;
        this.matcher = matcher;
    }

    public void describeTo(Description description) {
        description.appendText("A JSON array with value at " + this.position + " which matches: ");
        this.matcher.describeTo(description);
    }

    public boolean matchesSafely(JsonNode node) {
        if (!node.isArray()) {
            return false;
        }
        Iterator nodeIterator = node.elements();
        int nodeCount = 0;
        while (nodeIterator.hasNext()) {
            JsonNode currentNode = (JsonNode)nodeIterator.next();
            if (nodeCount == this.position) {
                return this.matcher.matches((Object)currentNode.textValue());
            }
            ++nodeCount;
        }
        return false;
    }
}

