/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETClient;
import com.exacttarget.fuelsdk.ETDataExtensionColumn;
import com.exacttarget.fuelsdk.ETDataExtensionRow;
import com.exacttarget.fuelsdk.ETExpression;
import com.exacttarget.fuelsdk.ETFilter;
import com.exacttarget.fuelsdk.ETResponse;
import com.exacttarget.fuelsdk.ETResult;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.ETSoapObject;
import com.exacttarget.fuelsdk.annotations.ExternalName;
import com.exacttarget.fuelsdk.annotations.InternalName;
import com.exacttarget.fuelsdk.annotations.RestObject;
import com.exacttarget.fuelsdk.annotations.SoapObject;
import com.exacttarget.fuelsdk.internal.APIObject;
import com.exacttarget.fuelsdk.internal.APIProperty;
import com.exacttarget.fuelsdk.internal.Attribute;
import com.exacttarget.fuelsdk.internal.DataExtension;
import com.exacttarget.fuelsdk.internal.DataExtensionObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RestObject(path="/data/v1/customobjectdata/key/{key}/rowset", primaryKey="key", collection="items", totalCount="count")
@SoapObject(internalType=DataExtension.class, unretrievable={"ID", "Fields", "SendableDataExtensionField", "SendableSubscriberField"})
public class ETDataExtension
extends ETSoapObject {
    static final int DEFAULT_PAGE_SIZE = 2500;
    private static Logger logger = Logger.getLogger(ETDataExtension.class);
    @ExternalName(value="id")
    @InternalName(value="objectID")
    private String id = null;
    @ExternalName(value="key")
    @InternalName(value="customerKey")
    private String key = null;
    @ExternalName(value="name")
    private String name = null;
    @ExternalName(value="description")
    private String description = null;
    @ExternalName(value="createdDate")
    private Date createdDate = null;
    @ExternalName(value="modifiedDate")
    private Date modifiedDate = null;
    @ExternalName(value="folderId")
    @InternalName(value="categoryID")
    private Integer folderId = null;
    @ExternalName(value="columns")
    @InternalName(value="fields")
    private List<ETDataExtensionColumn> columns = new ArrayList<ETDataExtensionColumn>();
    @ExternalName(value="isSendable")
    private Boolean isSendable = null;
    @ExternalName(value="isTestable")
    private Boolean isTestable = null;
    @ExternalName(value="sendableDataExtensionField")
    private ETDataExtensionColumn sendableDataExtensionField;
    @ExternalName(value="sendableSubscriberField")
    private Attribute sendableSubscriberField;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Integer getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Integer folderId) {
        this.folderId = folderId;
    }

    public Attribute getSendableSubscriberField() {
        return this.sendableSubscriberField;
    }

    public void setSendableSubscriberField(Attribute sendableSubscriberField) {
        this.sendableSubscriberField = sendableSubscriberField;
    }

    public ETDataExtensionColumn getSendableDataExtensionField() {
        return this.sendableDataExtensionField;
    }

    public void setSendableDataExtensionField(ETDataExtensionColumn sendableDataExtensionField) {
        this.sendableDataExtensionField = sendableDataExtensionField;
    }

    public List<ETDataExtensionColumn> getColumns() {
        return this.columns;
    }

    public ETDataExtensionColumn getColumn(String name) {
        for (ETDataExtensionColumn column : this.columns) {
            if (!column.getName().equals(name.toLowerCase())) continue;
            return column;
        }
        return null;
    }

    public void addColumn(String name) {
        this.addColumn(name, null, null, null, null, null, null, null);
    }

    public void addColumn(String name, ETDataExtensionColumn.Type type) {
        this.addColumn(name, type, null, null, null, null, null, null);
    }

    public void addColumn(String name, Boolean isPrimaryKey) {
        this.addColumn(name, null, null, null, null, isPrimaryKey, null, null);
    }

    public void addColumn(String name, ETDataExtensionColumn.Type type, Boolean isPrimaryKey) {
        this.addColumn(name, type, null, null, null, isPrimaryKey, null, null);
    }

    public void addColumn(String name, ETDataExtensionColumn.Type type, Integer length, Integer precision, Integer scale, Boolean isPrimaryKey, Boolean isRequired, String defaultValue) {
        ETDataExtensionColumn column = new ETDataExtensionColumn();
        column.setName(name.toLowerCase());
        if (type != null) {
            column.setType(type);
        } else {
            column.setType(ETDataExtensionColumn.Type.TEXT);
        }
        if (column.getType() == ETDataExtensionColumn.Type.TEXT) {
            if (length != null) {
                column.setLength(length);
            } else {
                column.setLength(50);
            }
        }
        if (column.getType() == ETDataExtensionColumn.Type.DECIMAL) {
            if (precision != null) {
                column.setPrecision(precision);
            } else {
                column.setPrecision(18);
            }
            if (scale != null) {
                column.setScale(scale);
            } else {
                column.setScale(0);
            }
        }
        column.setIsPrimaryKey(isPrimaryKey);
        if (isPrimaryKey != null && isPrimaryKey.booleanValue()) {
            column.setIsRequired(true);
        } else {
            column.setIsRequired(isRequired);
        }
        column.setDefaultValue(defaultValue);
        this.addColumn(column);
    }

    public void addColumn(ETDataExtensionColumn column) {
        this.columns.add(column);
    }

    public List<String> getColumnNames() throws ETSdkException {
        if (this.columns == null) {
            this.columns = this.retrieveColumns();
        }
        return ETDataExtension.getColumnNames(this.columns);
    }

    public Boolean getIsSendable() {
        return this.isSendable;
    }

    public void setIsSendable(Boolean isSendable) {
        this.isSendable = isSendable;
    }

    public Boolean getIsTestable() {
        return this.isTestable;
    }

    public void setIsTestable(Boolean isTestable) {
        this.isTestable = isTestable;
    }

    @Deprecated
    public String getCustomerKey() {
        return this.getKey();
    }

    @Deprecated
    public void setCustomerKey(String customerKey) {
        this.setKey(customerKey);
    }

    @Deprecated
    public Integer getCategoryId() {
        return this.getFolderId();
    }

    @Deprecated
    public void setCategoryId(Integer categoryId) {
        this.setFolderId(categoryId);
    }

    public static ETResponse<ETDataExtensionRow> select(ETClient client, String dataExtension, ETFilter filter) throws ETSdkException {
        return ETDataExtension.select(client, dataExtension, null, null, filter);
    }

    public static ETResponse<ETDataExtensionRow> select(ETClient client, String dataExtension, String ... filter) throws ETSdkException {
        return ETDataExtension.select(client, dataExtension, null, null, ETFilter.parse(filter));
    }

    public static ETResponse<ETDataExtensionRow> select(ETClient client, String dataExtension, Integer page, Integer pageSize, ETFilter filter) throws ETSdkException {
        String name = null;
        ETExpression e = ETExpression.parse(dataExtension);
        if (e.getProperty().toLowerCase().equals("key") && e.getOperator() == ETExpression.Operator.EQUALS) {
            name = e.getValue();
            if (filter.getProperties().isEmpty()) {
                filter.setProperties(ETDataExtension.retrieveColumnNames(client, name));
            }
        } else if (e.getProperty().toLowerCase().equals("name") && e.getOperator() == ETExpression.Operator.EQUALS) {
            name = e.getValue();
            if (filter.getProperties().isEmpty()) {
                throw new ETSdkException("columns must be specified when retrieving data extensions by name");
            }
        } else {
            throw new ETSdkException("invalid data extension filter string");
        }
        ETResponse<ETDataExtensionRow> response = ETSoapObject.retrieve(client, "DataExtensionObject[" + name + "]", filter, ETDataExtensionRow.class);
        List<ETResult<ETDataExtensionRow>> rowSet = ETDataExtension.sortRowSet(response.getResults(), filter);
        if (page == null && (page = response.getPage()) == null) {
            page = 1;
        }
        int iPage = page;
        if (pageSize == null && (pageSize = response.getPageSize()) == null) {
            pageSize = 2500;
        }
        int iPageSize = pageSize;
        int pageStart = (iPage - 1) * iPageSize;
        int pageEnd = pageStart + iPageSize;
        if (pageStart < rowSet.size()) {
            if (pageEnd > rowSet.size()) {
                pageEnd = rowSet.size();
            }
        } else {
            pageEnd = pageStart;
        }
        List<ETResult<ETDataExtensionRow>> paginatedRowSet = rowSet.subList(pageStart, pageEnd);
        response = ETDataExtension.createResponse(response, paginatedRowSet, page, pageSize, pageEnd, rowSet.size());
        logger.debug((Object)("final response: " + response));
        return response;
    }

    private static List<ETResult<ETDataExtensionRow>> sortRowSet(List<ETResult<ETDataExtensionRow>> rowSet, ETFilter filter) throws ETSdkException {
        logger.debug((Object)("rowSet: " + rowSet));
        logger.debug((Object)("filter: " + filter));
        if (filter.getOrderBy() != null && filter.getOrderBy().size() > 0) {
            final String orderByColumn = filter.getOrderBy().get(0);
            List<String> list = filter.getProperties();
            if (list.contains(orderByColumn)) {
                final boolean sortAsc = filter.getOrderByAsc();
                List<ETResult<ETDataExtensionRow>> sortedRowSet = rowSet;
                Collections.sort(sortedRowSet, new Comparator<ETResult<ETDataExtensionRow>>(){

                    @Override
                    public int compare(ETResult<ETDataExtensionRow> o1, ETResult<ETDataExtensionRow> o2) {
                        if (o1.getObject().getColumn(orderByColumn) == null) {
                            return 0;
                        }
                        int result = o1.getObject().getColumn(orderByColumn).compareTo(o2.getObject().getColumn(orderByColumn));
                        return sortAsc ? result : -result;
                    }
                });
                rowSet = sortedRowSet;
                logger.debug((Object)("sortedRowSet: " + sortedRowSet));
            } else {
                throw new ETSdkException("Can't order by '" + orderByColumn + "' as it is not in selected columns list: " + list);
            }
        }
        return rowSet;
    }

    private static ETResponse<ETDataExtensionRow> createResponse(ETResponse<ETDataExtensionRow> response, List<ETResult<ETDataExtensionRow>> paginatedRowSet, Integer page, Integer pageSize, Integer pageEnd, Integer totalCount) {
        ETResponse<ETDataExtensionRow> pr = new ETResponse<ETDataExtensionRow>();
        pr.setResponseCode(response.getResponseCode());
        pr.setResponseMessage(response.getResponseMessage());
        pr.setStatus(response.getStatus());
        pr.setPage(page);
        pr.setPageSize(pageSize);
        pr.setTotalCount(totalCount);
        pr.setMoreResults(pageEnd < totalCount);
        pr.setRequestId(response.getRequestId());
        pr.getResults().addAll(paginatedRowSet);
        return pr;
    }

    public static ETResponse<ETDataExtensionRow> select(ETClient client, String dataExtension, Integer page, Integer pageSize, String ... filter) throws ETSdkException {
        return ETDataExtension.select(client, dataExtension, page, pageSize, ETFilter.parse(filter));
    }

    @Deprecated
    public static ETResponse<ETDataExtensionRow> select(ETClient client, String dataExtension, ETFilter filter, String ... columns) throws ETSdkException {
        return ETDataExtension.select(client, dataExtension, filter, null, null, columns);
    }

    @Deprecated
    public static ETResponse<ETDataExtensionRow> select(ETClient client, String dataExtension, ETFilter filter, Integer page, Integer pageSize, String ... columns) throws ETSdkException {
        ETFilter f = ETFilter.parse(columns);
        f.setExpression(filter.getExpression());
        return ETDataExtension.select(client, dataExtension, page, pageSize, f);
    }

    @Deprecated
    public static ETResponse<ETDataExtensionRow> select(ETClient client, String dataExtension, String filter, Integer page, Integer pageSize, String ... columns) throws ETSdkException {
        return ETDataExtension.select(client, dataExtension, ETFilter.parse(filter), page, pageSize, columns);
    }

    public ETResponse<ETDataExtensionRow> select(ETFilter filter) throws ETSdkException {
        return this.select((Integer)null, (Integer)null, filter);
    }

    public ETResponse<ETDataExtensionRow> select(String ... filter) throws ETSdkException {
        ETFilter fil = ETFilter.parse(filter);
        return this.select((Integer)null, (Integer)null, fil);
    }

    public ETResponse<ETDataExtensionRow> select(Integer page, Integer pageSize, ETFilter filter) throws ETSdkException {
        if (filter.getProperties().isEmpty()) {
            filter.setProperties(this.getColumnNames());
        }
        return ETDataExtension.select(this.getClient(), "key=" + this.getKey(), page, pageSize, filter);
    }

    public ETResponse<ETDataExtensionRow> select(Integer page, Integer pageSize, String ... filter) throws ETSdkException {
        return this.select(page, pageSize, ETFilter.parse(filter));
    }

    @Deprecated
    public ETResponse<ETDataExtensionRow> select(ETFilter filter, String ... columns) throws ETSdkException {
        return this.select(filter, (Integer)null, (Integer)null, columns);
    }

    @Deprecated
    public ETResponse<ETDataExtensionRow> select(ETFilter filter, Integer page, Integer pageSize, String ... columns) throws ETSdkException {
        ETFilter f = ETFilter.parse(columns);
        f.setExpression(filter.getExpression());
        if (f.getProperties().isEmpty()) {
            f.setProperties(this.getColumnNames());
        }
        return ETDataExtension.select(this.getClient(), "key=" + this.getKey(), page, pageSize, f);
    }

    @Deprecated
    public ETResponse<ETDataExtensionRow> select(String filter, Integer page, Integer pageSize, String ... columns) throws ETSdkException {
        return this.select(ETFilter.parse(filter), page, pageSize, columns);
    }

    public ETResponse<ETDataExtensionRow> insert(ETDataExtensionRow ... rows) throws ETSdkException {
        return this.insert(Arrays.asList(rows));
    }

    public ETResponse<ETDataExtensionRow> insert(List<ETDataExtensionRow> rows) throws ETSdkException {
        for (ETDataExtensionRow row : rows) {
            if (row.getDataExtensionKey() != null) continue;
            row.setDataExtensionKey(this.key);
        }
        return ETSoapObject.create(this.getClient(), rows);
    }

    public ETResponse<ETDataExtensionRow> update(ETDataExtensionRow ... rows) throws ETSdkException {
        return this.update(Arrays.asList(rows));
    }

    public ETResponse<ETDataExtensionRow> update(List<ETDataExtensionRow> rows) throws ETSdkException {
        for (ETDataExtensionRow row : rows) {
            if (row.getDataExtensionKey() != null) continue;
            row.setDataExtensionKey(this.key);
        }
        return ETSoapObject.update(this.getClient(), rows);
    }

    public ETResponse<ETDataExtensionRow> delete(ETDataExtensionRow ... rows) throws ETSdkException {
        return this.delete(Arrays.asList(rows));
    }

    public ETResponse<ETDataExtensionRow> delete(List<ETDataExtensionRow> rows) throws ETSdkException {
        ArrayList<APIObject> internalRows = new ArrayList<APIObject>();
        for (ETDataExtensionRow row : rows) {
            DataExtensionObject internalRow = new DataExtensionObject();
            DataExtensionObject.Keys keys = new DataExtensionObject.Keys();
            this.hydrate();
            for (ETDataExtensionColumn column : this.columns) {
                if (!column.getIsPrimaryKey().booleanValue()) continue;
                APIProperty property = new APIProperty();
                property.setName(column.getName());
                property.setValue(row.getColumn(property.getName()));
                keys.getKey().add(property);
            }
            internalRow.setName(this.name);
            internalRow.setKeys(keys);
            internalRows.add(internalRow);
        }
        return ETSoapObject.delete(this.getClient(), internalRows, true);
    }

    public ETResponse<ETDataExtensionRow> update(String filter, String ... values) throws ETSdkException {
        List<ETDataExtensionRow> rows = this.getMatchingRows(filter);
        for (ETDataExtensionRow row : rows) {
            for (String value : values) {
                ETExpression expression = ETExpression.parse(value);
                if (expression.getOperator() != ETExpression.Operator.EQUALS) {
                    throw new ETSdkException("must be an assign operation: " + expression);
                }
                row.setColumn(expression.getProperty(), expression.getValue());
            }
        }
        return this.update(rows);
    }

    public ETResponse<ETDataExtensionRow> delete(String filter) throws ETSdkException {
        List<ETDataExtensionRow> rows = this.getMatchingRows(filter);
        return this.delete(rows);
    }

    public void hydrate() throws ETSdkException {
        this.retrieveColumns();
    }

    public static List<ETDataExtensionColumn> retrieveColumns(ETClient client, String key) throws ETSdkException {
        client.refreshToken();
        ETExpression expression = new ETExpression();
        expression.setProperty("DataExtension.CustomerKey");
        expression.setOperator(ETExpression.Operator.EQUALS);
        expression.addValue(key);
        ETFilter filter = new ETFilter();
        filter.setExpression(expression);
        ETResponse<ETDataExtensionColumn> response = ETDataExtensionColumn.retrieve(client, ETDataExtensionColumn.class, null, null, filter);
        return response.getObjects();
    }

    public List<ETDataExtensionColumn> retrieveColumns() throws ETSdkException {
        this.columns = ETDataExtension.retrieveColumns(this.getClient(), this.getKey());
        return this.columns;
    }

    private static List<String> retrieveColumnNames(ETClient client, String key) throws ETSdkException {
        return ETDataExtension.getColumnNames(ETDataExtension.retrieveColumns(client, key));
    }

    private List<ETDataExtensionRow> getMatchingRows(String filter) throws ETSdkException {
        ArrayList<ETDataExtensionRow> rows = new ArrayList<ETDataExtensionRow>();
        this.hydrate();
        ArrayList<String> primaryKeyColumnNames = new ArrayList<String>();
        for (ETDataExtensionColumn column : this.columns) {
            if (!column.getIsPrimaryKey().booleanValue()) continue;
            primaryKeyColumnNames.add(column.getName());
        }
        int page = 1;
        int page_size = 2500;
        ETResponse<ETDataExtensionRow> response = null;
        do {
            ETFilter parsedFilter = ETFilter.parse(filter);
            parsedFilter.setProperties(primaryKeyColumnNames);
            response = this.select((Integer)page++, (Integer)page_size, parsedFilter);
            rows.addAll(response.getObjects());
        } while (response.hasMoreResults().booleanValue());
        return rows;
    }

    private static List<String> getColumnNames(List<ETDataExtensionColumn> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ETDataExtensionColumn column : columns) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }
}

