/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETApiObject;
import com.exacttarget.fuelsdk.ETObject;
import com.exacttarget.fuelsdk.ETResult;
import com.exacttarget.fuelsdk.annotations.PrettyPrint;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETResponse<T extends ETApiObject>
extends ETObject {
    private static Logger logger = Logger.getLogger(ETResponse.class);
    @PrettyPrint
    private ETResult<T> batchResult = null;
    @PrettyPrint
    private List<ETResult<T>> individualResults = new ArrayList<ETResult<T>>();
    @PrettyPrint
    private Boolean moreResults = false;
    @PrettyPrint
    private Integer page = null;
    @PrettyPrint
    private Integer pageSize = null;
    @PrettyPrint
    private Integer totalCount = null;

    public ETResult.Status getStatus() {
        if (this.batchResult != null) {
            return this.batchResult.getStatus();
        }
        return null;
    }

    public void setStatus(ETResult.Status status) {
        if (this.batchResult == null) {
            this.batchResult = new ETResult();
        }
        this.batchResult.setStatus(status);
    }

    public String getRequestId() {
        if (this.batchResult != null) {
            return this.batchResult.getRequestId();
        }
        return null;
    }

    public void setRequestId(String requestId) {
        if (this.batchResult == null) {
            this.batchResult = new ETResult();
        }
        this.batchResult.setRequestId(requestId);
    }

    public String getResponseCode() {
        if (this.batchResult != null) {
            return this.batchResult.getResponseCode();
        }
        return null;
    }

    public void setResponseCode(String responseCode) {
        if (this.batchResult == null) {
            this.batchResult = new ETResult();
        }
        this.batchResult.setResponseCode(responseCode);
    }

    public String getResponseMessage() {
        if (this.batchResult != null) {
            return this.batchResult.getResponseMessage();
        }
        return null;
    }

    public void setResponseMessage(String responseMessage) {
        if (this.batchResult == null) {
            this.batchResult = new ETResult();
        }
        this.batchResult.setResponseMessage(responseMessage);
    }

    public T getObject() {
        return this.getResult().getObject();
    }

    public List<T> getObjects() {
        ArrayList<T> objects = new ArrayList<T>();
        for (ETResult<T> result : this.individualResults) {
            objects.add(result.getObject());
        }
        return objects;
    }

    public ETResult<T> getResult() {
        if (this.individualResults.size() == 0) {
            return null;
        }
        if (this.individualResults.size() > 1) {
            logger.warn((Object)"getResult() called on response with results > 1");
        }
        return this.individualResults.get(0);
    }

    public List<ETResult<T>> getResults() {
        return this.individualResults;
    }

    public void addResult(ETResult<T> result) {
        this.individualResults.add(result);
    }

    public Boolean hasMoreResults() {
        return this.moreResults;
    }

    public void setMoreResults(Boolean moreResults) {
        this.moreResults = moreResults;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    @Deprecated
    public String getStatusCode() {
        return this.getResponseCode();
    }

    @Deprecated
    public void setStatusCode(String statusCode) {
        this.setResponseCode(statusCode);
    }

    @Deprecated
    public String getStatusMessage() {
        return this.getResponseMessage();
    }

    @Deprecated
    public void setStatusMessage(String statusMessage) {
        this.setResponseMessage(statusMessage);
    }
}

