/*
 * Decompiled with CFR 0.152.
 */
package com.exacttarget.fuelsdk;

import com.exacttarget.fuelsdk.ETApiObject;
import com.exacttarget.fuelsdk.ETClient;
import com.exacttarget.fuelsdk.ETDataExtension;
import com.exacttarget.fuelsdk.ETDataExtensionColumn;
import com.exacttarget.fuelsdk.ETDataExtensionRow;
import com.exacttarget.fuelsdk.ETEmail;
import com.exacttarget.fuelsdk.ETExpression;
import com.exacttarget.fuelsdk.ETExtractDescription;
import com.exacttarget.fuelsdk.ETFilter;
import com.exacttarget.fuelsdk.ETFolder;
import com.exacttarget.fuelsdk.ETList;
import com.exacttarget.fuelsdk.ETObject;
import com.exacttarget.fuelsdk.ETProfileAttribute;
import com.exacttarget.fuelsdk.ETResponse;
import com.exacttarget.fuelsdk.ETResult;
import com.exacttarget.fuelsdk.ETSdkException;
import com.exacttarget.fuelsdk.ETSoapConnection;
import com.exacttarget.fuelsdk.ETSubscriber;
import com.exacttarget.fuelsdk.ETTriggeredEmail;
import com.exacttarget.fuelsdk.annotations.ExternalName;
import com.exacttarget.fuelsdk.annotations.InternalName;
import com.exacttarget.fuelsdk.annotations.InternalProperty;
import com.exacttarget.fuelsdk.annotations.SoapObject;
import com.exacttarget.fuelsdk.internal.APIObject;
import com.exacttarget.fuelsdk.internal.APIProperty;
import com.exacttarget.fuelsdk.internal.ComplexFilterPart;
import com.exacttarget.fuelsdk.internal.CreateOptions;
import com.exacttarget.fuelsdk.internal.CreateRequest;
import com.exacttarget.fuelsdk.internal.CreateResponse;
import com.exacttarget.fuelsdk.internal.CreateResult;
import com.exacttarget.fuelsdk.internal.DataExtension;
import com.exacttarget.fuelsdk.internal.DataExtensionField;
import com.exacttarget.fuelsdk.internal.DataExtensionFieldType;
import com.exacttarget.fuelsdk.internal.DataExtensionObject;
import com.exacttarget.fuelsdk.internal.DataFolder;
import com.exacttarget.fuelsdk.internal.DeleteOptions;
import com.exacttarget.fuelsdk.internal.DeleteRequest;
import com.exacttarget.fuelsdk.internal.DeleteResponse;
import com.exacttarget.fuelsdk.internal.DeleteResult;
import com.exacttarget.fuelsdk.internal.Email;
import com.exacttarget.fuelsdk.internal.EmailType;
import com.exacttarget.fuelsdk.internal.ExtractDescription;
import com.exacttarget.fuelsdk.internal.FilterPart;
import com.exacttarget.fuelsdk.internal.List;
import com.exacttarget.fuelsdk.internal.ListClassificationEnum;
import com.exacttarget.fuelsdk.internal.ListTypeEnum;
import com.exacttarget.fuelsdk.internal.LogicalOperators;
import com.exacttarget.fuelsdk.internal.ObjectExtension;
import com.exacttarget.fuelsdk.internal.RetrieveRequest;
import com.exacttarget.fuelsdk.internal.RetrieveRequestMsg;
import com.exacttarget.fuelsdk.internal.RetrieveResponseMsg;
import com.exacttarget.fuelsdk.internal.SimpleFilterPart;
import com.exacttarget.fuelsdk.internal.SimpleOperators;
import com.exacttarget.fuelsdk.internal.Soap;
import com.exacttarget.fuelsdk.internal.Subscriber;
import com.exacttarget.fuelsdk.internal.SubscriberStatus;
import com.exacttarget.fuelsdk.internal.TriggeredSendDefinition;
import com.exacttarget.fuelsdk.internal.TriggeredSendStatusEnum;
import com.exacttarget.fuelsdk.internal.UpdateOptions;
import com.exacttarget.fuelsdk.internal.UpdateRequest;
import com.exacttarget.fuelsdk.internal.UpdateResponse;
import com.exacttarget.fuelsdk.internal.UpdateResult;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ETSoapObject
extends ETApiObject {
    private static Logger logger = Logger.getLogger(ETSoapObject.class);
    public static final int PAGE_SIZE = 2500;

    public ETSoapObject() {
        this.registerConverters();
    }

    public static <T extends ETSoapObject> ETResponse<T> retrieve(ETClient client, Class<T> type, Integer page, Integer pageSize, ETFilter filter) throws ETSdkException {
        if (page != null) {
            throw new ETSdkException("page argument not supported on this object type");
        }
        if (pageSize != null) {
            throw new ETSdkException("pageSize argument not supported on this object type");
        }
        if (filter.getOrderBy().size() != 0) {
            throw new ETSdkException("order by argument not supported on this object type");
        }
        return ETSoapObject.retrieve(client, null, filter, type);
    }

    protected static <T extends ETSoapObject> ETResponse<T> retrieve(ETClient client, String soapObjectName, ETFilter filter, Class<T> type) throws ETSdkException {
        return ETSoapObject.retrieve(client, soapObjectName, filter, null, type);
    }

    protected static <T extends ETSoapObject> ETResponse<T> retrieve(ETClient client, String continueRequest, Class<T> type) throws ETSdkException {
        return ETSoapObject.retrieve(client, null, new ETFilter(), continueRequest, type);
    }

    protected static <T extends ETSoapObject> ETResponse<T> retrieve(ETClient client, String soapObjectName, ETFilter filter, String continueRequest, Class<T> type) throws ETSdkException {
        ETResponse response = new ETResponse();
        ETSoapConnection connection = client.getSoapConnection();
        client.refreshToken();
        Class<T> externalType = type;
        SoapObject internalTypeAnnotation = externalType.getAnnotation(SoapObject.class);
        assert (internalTypeAnnotation != null);
        Class<? extends APIObject> internalType = internalTypeAnnotation.internalType();
        assert (internalType != null);
        ETExpression expression = filter.getExpression();
        java.util.List<String> externalProperties = filter.getProperties();
        java.util.List<String> internalProperties = null;
        if (externalProperties.size() > 0) {
            internalProperties = new ArrayList<String>();
            for (String externalProperty : externalProperties) {
                String internalProperty = ETSoapObject.getInternalProperty(externalType, externalProperty);
                assert (internalProperty != null);
                internalProperties.add(internalProperty);
            }
        } else {
            internalProperties = ETSoapObject.getInternalProperties(externalType);
            for (String string : internalTypeAnnotation.unretrievable()) {
                internalProperties.remove(string);
            }
        }
        Soap soap = null;
        RetrieveRequest retrieveRequest = new RetrieveRequest();
        if (continueRequest == null) {
            if (soapObjectName != null) {
                retrieveRequest.setObjectType(soapObjectName);
                soap = connection.getSoap("retrieve", soapObjectName);
            } else {
                retrieveRequest.setObjectType(internalType.getSimpleName());
                soap = connection.getSoap("retrieve", internalType.getSimpleName());
            }
            retrieveRequest.getProperties().addAll(internalProperties);
            if (expression.getOperator() != null) {
                String property = expression.getProperty();
                if (property != null) {
                    expression.setProperty(ETSoapObject.getInternalProperty(type, property));
                }
                for (ETExpression subexpression : expression.getSubexpressions()) {
                    String p = subexpression.getProperty();
                    if (p == null) continue;
                    subexpression.setProperty(ETSoapObject.getInternalProperty(type, p));
                }
                retrieveRequest.setFilter(ETSoapObject.toFilterPart(expression));
            }
        } else if (continueRequest != null) {
            retrieveRequest.setContinueRequest(continueRequest);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"RetrieveRequest:");
            logger.trace((Object)("  objectType = " + retrieveRequest.getObjectType()));
            StringBuilder line = new StringBuilder("  properties = { ");
            for (String property : retrieveRequest.getProperties()) {
                line.append(property).append(", ");
            }
            if (retrieveRequest.getProperties().size() > 0) {
                line.setLength(line.length() - 2);
            }
            line.append(" }");
            logger.trace((Object)line.toString());
            if (filter != null) {
                logger.trace((Object)("  filter = " + ETSoapObject.toFilterPart(expression)));
            }
        }
        logger.trace((Object)"calling soap.retrieve...");
        RetrieveRequestMsg retrieveRequestMsg = new RetrieveRequestMsg();
        retrieveRequestMsg.setRetrieveRequest(retrieveRequest);
        RetrieveResponseMsg retrieveResponseMsg = soap.retrieve(retrieveRequestMsg);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"RetrieveResponseMsg:");
            logger.trace((Object)("  requestId = " + retrieveResponseMsg.getRequestID()));
            logger.trace((Object)("  overallStatus = " + retrieveResponseMsg.getOverallStatus()));
            logger.trace((Object)"  results = {");
            for (APIObject result : retrieveResponseMsg.getResults()) {
                logger.trace((Object)("    " + result));
            }
            logger.trace((Object)"  }");
        }
        response.setRequestId(retrieveResponseMsg.getRequestID());
        if (retrieveResponseMsg.getOverallStatus().equals("OK")) {
            response.setStatus(ETResult.Status.OK);
        } else if (retrieveResponseMsg.getOverallStatus().equals("Error")) {
            response.setStatus(ETResult.Status.ERROR);
        }
        response.setResponseCode(retrieveResponseMsg.getOverallStatus());
        response.setResponseMessage(retrieveResponseMsg.getOverallStatus());
        for (APIObject internalObject : retrieveResponseMsg.getResults()) {
            ETSoapObject externalObject = null;
            try {
                externalObject = (ETSoapObject)externalType.newInstance();
            }
            catch (Exception ex) {
                throw new ETSdkException("could not instantiate " + externalType.getName(), ex);
            }
            externalObject.setClient(client);
            externalObject.fromInternal(internalObject);
            ETResult<ETSoapObject> result = new ETResult<ETSoapObject>();
            result.setObject(externalObject);
            response.addResult(result);
        }
        if (retrieveResponseMsg.getOverallStatus().equals("MoreDataAvailable")) {
            response.setMoreResults(true);
        }
        return response;
    }

    public static <T extends ETSoapObject> ETResponse<T> create(ETClient client, java.util.List<T> objects) throws ETSdkException {
        ETResponse response = new ETResponse();
        if (objects == null || objects.size() == 0) {
            response.setStatus(ETResult.Status.OK);
            return response;
        }
        ETSoapConnection connection = client.getSoapConnection();
        client.refreshToken();
        String obj = "";
        CreateRequest createRequest = new CreateRequest();
        createRequest.setOptions(new CreateOptions());
        for (Object object : objects) {
            ((ETObject)object).setClient(client);
            createRequest.getObjects().add(((ETSoapObject)object).toInternal());
            obj = obj + object.getClass().getSimpleName().substring(2);
        }
        Soap soap = connection.getSoap("create", obj);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"CreateRequest:");
            logger.trace((Object)"  objects = {");
            for (APIObject object : createRequest.getObjects()) {
                logger.trace((Object)("    " + object));
            }
            logger.trace((Object)"  }");
        }
        logger.trace((Object)"calling soap.create...");
        CreateResponse createResponse = soap.create(createRequest);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"CreateResponse:");
            logger.trace((Object)("  requestId = " + createResponse.getRequestID()));
            logger.trace((Object)("  overallStatus = " + createResponse.getOverallStatus()));
            logger.trace((Object)"  results = {");
            for (CreateResult result : createResponse.getResults()) {
                logger.trace((Object)("    " + result));
            }
            logger.trace((Object)"  }");
        }
        response.setRequestId(createResponse.getRequestID());
        if (createResponse.getOverallStatus().equals("OK")) {
            response.setStatus(ETResult.Status.OK);
        } else if (createResponse.getOverallStatus().equals("Error")) {
            response.setStatus(ETResult.Status.ERROR);
        }
        response.setResponseCode(createResponse.getOverallStatus());
        response.setResponseMessage(createResponse.getOverallStatus());
        for (CreateResult createResult : createResponse.getResults()) {
            Class<?> externalType = ((ETSoapObject)objects.get(0)).getClass();
            ETSoapObject externalObject = null;
            try {
                externalObject = (ETSoapObject)externalType.newInstance();
            }
            catch (Exception ex) {
                throw new ETSdkException("could not instantiate " + externalType.getName(), ex);
            }
            externalObject.setClient(client);
            APIObject internalObject = createResult.getObject();
            if (internalObject != null) {
                externalObject.fromInternal(createResult.getObject());
            } else {
                externalObject.setId(Integer.toString(createResult.getNewID()));
            }
            ETResult<ETSoapObject> result = new ETResult<ETSoapObject>();
            if (createResult.getStatusCode().equals("OK")) {
                result.setStatus(ETResult.Status.OK);
            } else if (createResult.getStatusCode().equals("Error")) {
                result.setStatus(ETResult.Status.ERROR);
            }
            result.setResponseCode(createResult.getStatusCode());
            result.setResponseMessage(createResult.getStatusMessage());
            result.setErrorCode(createResult.getErrorCode());
            if (result.getResponseCode().equals("OK")) {
                result.setObject(externalObject);
            }
            response.addResult(result);
        }
        return response;
    }

    public static <T extends ETSoapObject> ETResponse<T> update(ETClient client, java.util.List<T> objects) throws ETSdkException {
        ETResponse response = new ETResponse();
        if (objects == null || objects.size() == 0) {
            response.setStatus(ETResult.Status.OK);
            return response;
        }
        ETSoapConnection connection = client.getSoapConnection();
        client.refreshToken();
        String obj = "";
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.setOptions(new UpdateOptions());
        for (Object object : objects) {
            ((ETObject)object).setClient(client);
            updateRequest.getObjects().add(((ETSoapObject)object).toInternal());
            obj = obj + object.getClass().getSimpleName().substring(2);
        }
        Soap soap = connection.getSoap("update", obj);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"UpdateRequest:");
            logger.trace((Object)"  objects = {");
            for (APIObject object : updateRequest.getObjects()) {
                logger.trace((Object)("    " + object));
            }
            logger.trace((Object)"  }");
        }
        logger.trace((Object)"calling soap.update...");
        UpdateResponse updateResponse = soap.update(updateRequest);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"UpdateResponse:");
            logger.trace((Object)("  requestId = " + updateResponse.getRequestID()));
            logger.trace((Object)("  overallStatus = " + updateResponse.getOverallStatus()));
            logger.trace((Object)"  results = {");
            for (UpdateResult result : updateResponse.getResults()) {
                logger.trace((Object)("    " + result));
            }
            logger.trace((Object)"  }");
        }
        response.setRequestId(updateResponse.getRequestID());
        if (updateResponse.getOverallStatus().equals("OK")) {
            response.setStatus(ETResult.Status.OK);
        } else if (updateResponse.getOverallStatus().equals("Error")) {
            response.setStatus(ETResult.Status.ERROR);
        }
        response.setResponseCode(updateResponse.getOverallStatus());
        response.setResponseMessage(updateResponse.getOverallStatus());
        for (UpdateResult updateResult : updateResponse.getResults()) {
            Class<?> externalType = ((ETSoapObject)objects.get(0)).getClass();
            ETSoapObject externalObject = null;
            try {
                externalObject = (ETSoapObject)externalType.newInstance();
            }
            catch (Exception ex) {
                throw new ETSdkException("could not instantiate " + externalType.getName(), ex);
            }
            externalObject.setClient(client);
            APIObject internalObject = updateResult.getObject();
            if (internalObject != null) {
                externalObject.fromInternal(updateResult.getObject());
            }
            ETResult<ETSoapObject> result = new ETResult<ETSoapObject>();
            if (updateResult.getStatusCode().equals("OK")) {
                result.setStatus(ETResult.Status.OK);
            } else if (updateResult.getStatusCode().equals("Error")) {
                result.setStatus(ETResult.Status.ERROR);
            }
            result.setResponseCode(updateResult.getStatusCode());
            result.setResponseMessage(updateResult.getStatusMessage());
            result.setErrorCode(updateResult.getErrorCode());
            if (result.getResponseCode().equals("OK")) {
                result.setObject(externalObject);
            }
            response.addResult(result);
        }
        return response;
    }

    public static <T extends ETSoapObject> ETResponse<T> delete(ETClient client, java.util.List<T> objects) throws ETSdkException {
        ArrayList<APIObject> internalObjects = new ArrayList<APIObject>();
        for (ETSoapObject object : objects) {
            object.setClient(client);
            internalObjects.add(object.toInternal());
        }
        return ETSoapObject.delete(client, internalObjects, true);
    }

    protected static <T extends ETSoapObject> ETResponse<T> delete(ETClient client, java.util.List<APIObject> objects, boolean internal) throws ETSdkException {
        ETResponse response = new ETResponse();
        if (objects == null || objects.size() == 0) {
            response.setStatus(ETResult.Status.OK);
            return response;
        }
        ETSoapConnection connection = client.getSoapConnection();
        client.refreshToken();
        String obj = "";
        for (APIObject object : objects) {
            obj = obj + object.getClass().getSimpleName();
        }
        Soap soap = connection.getSoap("delete", obj);
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.setOptions(new DeleteOptions());
        deleteRequest.getObjects().addAll(objects);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"DeleteRequest:");
            logger.trace((Object)"  objects = {");
            for (APIObject object : deleteRequest.getObjects()) {
                logger.trace((Object)("    " + object));
            }
            logger.trace((Object)"  }");
        }
        logger.trace((Object)"calling soap.delete...");
        DeleteResponse deleteResponse = soap.delete(deleteRequest);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"DeleteResponse:");
            logger.trace((Object)("  requestId = " + deleteResponse.getRequestID()));
            logger.trace((Object)("  overallStatus = " + deleteResponse.getOverallStatus()));
            logger.trace((Object)"  results = {");
            for (DeleteResult result : deleteResponse.getResults()) {
                logger.trace((Object)("    " + result));
            }
            logger.trace((Object)"  }");
        }
        response.setRequestId(deleteResponse.getRequestID());
        if (deleteResponse.getOverallStatus().equals("OK")) {
            response.setStatus(ETResult.Status.OK);
        } else if (deleteResponse.getOverallStatus().equals("Error")) {
            response.setStatus(ETResult.Status.ERROR);
        }
        response.setResponseCode(deleteResponse.getOverallStatus());
        response.setResponseMessage(deleteResponse.getOverallStatus());
        for (DeleteResult deleteResult : deleteResponse.getResults()) {
            ETResult result = new ETResult();
            if (deleteResult.getStatusCode().equals("OK")) {
                result.setStatus(ETResult.Status.OK);
            } else if (deleteResult.getStatusCode().equals("Error")) {
                result.setStatus(ETResult.Status.ERROR);
            }
            result.setResponseCode(deleteResult.getStatusCode());
            result.setResponseMessage(deleteResult.getStatusMessage());
            result.setErrorCode(deleteResult.getErrorCode());
            response.addResult(result);
        }
        return response;
    }

    private void registerConverters() {
        ConvertUtilsBean convertUtils = BeanUtilsBean.getInstance().getConvertUtils();
        convertUtils.register((Converter)new ExternalObjectConverter(), ETDataExtension.class);
        convertUtils.register((Converter)new InternalObjectConverter(), DataExtension.class);
        convertUtils.register((Converter)new ExternalObjectConverter(), ETProfileAttribute.class);
        convertUtils.register((Converter)new ExternalObjectConverter(), ETDataExtensionColumn.class);
        convertUtils.register((Converter)new InternalObjectConverter(), DataExtensionField.class);
        convertUtils.register((Converter)new ExternalObjectConverter(), ETExtractDescription.class);
        convertUtils.register((Converter)new InternalObjectConverter(), ExtractDescription.class);
        convertUtils.register((Converter)new EnumConverter(), ETDataExtensionColumn.Type.class);
        convertUtils.register((Converter)new EnumConverter(), DataExtensionFieldType.class);
        convertUtils.register((Converter)new ExternalObjectConverter(), ETDataExtensionRow.class);
        convertUtils.register((Converter)new InternalObjectConverter(), DataExtensionObject.class);
        convertUtils.register((Converter)new DataExtensionRowConverter(), Map.class);
        convertUtils.register((Converter)new DataExtensionRowConverter(), ObjectExtension.Properties.class);
        convertUtils.register((Converter)new ExternalObjectConverter(), ETEmail.class);
        convertUtils.register((Converter)new InternalObjectConverter(), Email.class);
        convertUtils.register((Converter)new EnumConverter(), ETEmail.Type.class);
        convertUtils.register((Converter)new EnumConverter(), EmailType.class);
        convertUtils.register((Converter)new ExternalObjectConverter(), ETFolder.class);
        convertUtils.register((Converter)new InternalObjectConverter(), DataFolder.class);
        convertUtils.register((Converter)new ExternalObjectConverter(), ETList.class);
        convertUtils.register((Converter)new InternalObjectConverter(), List.class);
        convertUtils.register((Converter)new EnumConverter(), ETList.Classification.class);
        convertUtils.register((Converter)new EnumConverter(), ListClassificationEnum.class);
        convertUtils.register((Converter)new EnumConverter(), ETList.Type.class);
        convertUtils.register((Converter)new EnumConverter(), ListTypeEnum.class);
        convertUtils.register((Converter)new ExternalObjectConverter(), ETSubscriber.class);
        convertUtils.register((Converter)new InternalObjectConverter(), Subscriber.class);
        convertUtils.register((Converter)new EnumConverter(), ETSubscriber.Status.class);
        convertUtils.register((Converter)new EnumConverter(), ETSubscriber.Status.class);
        convertUtils.register((Converter)new EnumConverter(), SubscriberStatus.class);
        convertUtils.register((Converter)new EnumConverter(), ETTriggeredEmail.class);
        convertUtils.register((Converter)new EnumConverter(), TriggeredSendDefinition.class);
        convertUtils.register((Converter)new EnumConverter(), ETTriggeredEmail.Status.class);
        convertUtils.register((Converter)new EnumConverter(), TriggeredSendStatusEnum.class);
    }

    public ETSoapObject fromInternal(APIObject internalObject) throws ETSdkException {
        ETSoapObject externalObject = this;
        Class<?> externalType = externalObject.getClass();
        String externalTypeName = externalType.getSimpleName();
        Class<?> internalType = internalObject.getClass();
        String internalTypeName = internalType.getSimpleName();
        logger.trace((Object)("converting object from internal type " + internalTypeName));
        logger.trace((Object)("                    to external type " + externalTypeName));
        for (Field externalField : ETSoapObject.getAllFields(externalType)) {
            ExternalName externalName = externalField.getAnnotation(ExternalName.class);
            if (externalName == null) continue;
            String externalFieldName = externalField.getName();
            String internalFieldName = null;
            InternalName internalName = externalField.getAnnotation(InternalName.class);
            internalFieldName = internalName != null ? internalName.value() : externalFieldName;
            Object internalFieldValue = null;
            try {
                internalFieldValue = PropertyUtils.getProperty((Object)internalObject, (String)internalFieldName);
            }
            catch (Exception ex) {
                throw new ETSdkException("could not get property \"" + internalFieldName + "\" of object " + internalObject, ex);
            }
            if (internalFieldValue == null) continue;
            if (internalFieldValue instanceof java.util.List) {
                externalField.setAccessible(true);
                ArrayList<ETSoapObject> externalList = new ArrayList<ETSoapObject>();
                java.util.List internalList = (java.util.List)internalFieldValue;
                Type fieldType = externalField.getGenericType();
                assert (fieldType instanceof ParameterizedType);
                ParameterizedType parameterizedType = (ParameterizedType)fieldType;
                assert (parameterizedType.getActualTypeArguments().length == 1);
                Class externalItemType = (Class)parameterizedType.getActualTypeArguments()[0];
                for (APIObject internalItem : internalList) {
                    ETSoapObject externalItem = null;
                    try {
                        externalItem = (ETSoapObject)externalItemType.newInstance();
                    }
                    catch (Exception ex) {
                        throw new ETSdkException("could not instantiate " + externalItemType.getName(), ex);
                    }
                    externalList.add(externalItem.fromInternal(internalItem));
                }
                try {
                    externalField.set(externalObject, externalList);
                    continue;
                }
                catch (Exception ex) {
                    throw new ETSdkException("could not set field \"" + externalFieldName + "\" of object " + externalObject, ex);
                }
            }
            try {
                BeanUtils.setProperty((Object)externalObject, (String)externalFieldName, (Object)internalFieldValue);
            }
            catch (Exception ex) {
                throw new ETSdkException("could not set property \"" + externalFieldName + "\" of object " + externalObject, ex);
            }
            if (!logger.isTraceEnabled()) continue;
            Field internalField = ETSoapObject.getField(internalType, internalFieldName);
            Object externalFieldValue = null;
            try {
                externalFieldValue = PropertyUtils.getProperty((Object)externalObject, (String)externalFieldName);
            }
            catch (Exception ex) {
                throw new ETSdkException("could not get property \"" + externalFieldName + "\" of object " + externalObject, ex);
            }
            logger.trace((Object)("  converted field " + internalTypeName + "." + internalFieldName + " (type=" + internalField.getType().getSimpleName() + ", value=" + internalFieldValue + ")"));
            logger.trace((Object)("         to field " + externalTypeName + "." + externalFieldName + " (type=" + externalField.getType().getSimpleName() + ", value=" + externalFieldValue + ")"));
        }
        return externalObject;
    }

    public APIObject toInternal() throws ETSdkException {
        ETSoapObject externalObject = this;
        Class<?> externalType = externalObject.getClass();
        SoapObject internalTypeAnnotation = externalType.getAnnotation(SoapObject.class);
        assert (internalTypeAnnotation != null);
        Class<? extends APIObject> internalType = internalTypeAnnotation.internalType();
        assert (internalType != null);
        String externalTypeName = externalType.getSimpleName();
        String internalTypeName = internalType.getSimpleName();
        logger.trace((Object)("converting object from external type " + externalTypeName));
        logger.trace((Object)("                    to internal type " + internalTypeName));
        APIObject internalObject = null;
        try {
            internalObject = internalType.newInstance();
        }
        catch (Exception ex) {
            throw new ETSdkException("could not instantiate " + internalType.getName(), ex);
        }
        for (Field externalField : ETSoapObject.getAllFields(externalType)) {
            Field internalField;
            ExternalName externalName = externalField.getAnnotation(ExternalName.class);
            if (externalName == null) continue;
            String externalFieldName = externalField.getName();
            String internalFieldName = null;
            InternalName internalName = externalField.getAnnotation(InternalName.class);
            internalFieldName = internalName != null ? internalName.value() : externalFieldName;
            Object externalFieldValue = null;
            try {
                externalFieldValue = PropertyUtils.getProperty((Object)externalObject, (String)externalFieldName);
            }
            catch (Exception ex) {
                throw new ETSdkException("could not get property \"" + externalFieldName + "\" of object " + externalObject, ex);
            }
            if (externalFieldValue == null) continue;
            if (externalFieldValue instanceof java.util.List) {
                internalField = ETSoapObject.getField(internalType, internalFieldName);
                internalField.setAccessible(true);
                ArrayList<APIObject> internalList = new ArrayList<APIObject>();
                java.util.List externalList = (java.util.List)externalFieldValue;
                for (Object externalItem : externalList) {
                    internalList.add(((ETSoapObject)externalItem).toInternal());
                }
                if (internalFieldName.equals("fields")) {
                    Object externalItem;
                    DataExtension.Fields fields = new DataExtension.Fields();
                    externalItem = internalList.iterator();
                    while (externalItem.hasNext()) {
                        APIObject field = (APIObject)externalItem.next();
                        fields.getField().add((DataExtensionField)field);
                    }
                    try {
                        internalField.set(internalObject, fields);
                        continue;
                    }
                    catch (Exception ex) {
                        throw new ETSdkException("could not set field \"" + internalFieldName + "\" of object " + internalObject, ex);
                    }
                }
                try {
                    internalField.set(internalObject, internalList);
                    continue;
                }
                catch (Exception ex) {
                    throw new ETSdkException("could not set field \"" + internalFieldName + "\" of object " + internalObject, ex);
                }
            }
            try {
                BeanUtils.setProperty((Object)internalObject, (String)internalFieldName, (Object)externalFieldValue);
            }
            catch (Exception ex) {
                throw new ETSdkException("could not set property \"" + internalFieldName + "\" of object " + internalObject, ex);
            }
            if (!logger.isTraceEnabled()) continue;
            internalField = ETSoapObject.getField(internalType, internalFieldName);
            Object internalFieldValue = null;
            try {
                internalFieldValue = PropertyUtils.getProperty((Object)internalObject, (String)internalFieldName);
            }
            catch (Exception ex) {
                throw new ETSdkException("could not get property \"" + internalFieldName + "\" of object " + internalObject, ex);
            }
            logger.trace((Object)("  converted field " + externalTypeName + "." + externalFieldName + " (type=" + externalField.getType().getSimpleName() + ", value=" + externalFieldValue + ")"));
            logger.trace((Object)("         to field " + internalTypeName + "." + internalFieldName + " (type=" + internalField.getType().getSimpleName() + ", value=" + internalFieldValue + ")"));
        }
        return internalObject;
    }

    protected static String getInternalProperty(Class<? extends ETSoapObject> type, String name) throws ETSdkException {
        String internalProperty = null;
        Class<? extends ETSoapObject> externalType = type;
        Field externalField = null;
        try {
            externalField = ETSoapObject.getField(externalType, name);
        }
        catch (ETSdkException ex) {
            return name;
        }
        InternalProperty internalPropertyAnnotation = externalField.getAnnotation(InternalProperty.class);
        if (internalPropertyAnnotation != null) {
            internalProperty = internalPropertyAnnotation.value();
        } else {
            SoapObject internalTypeAnnotation = externalType.getAnnotation(SoapObject.class);
            assert (internalTypeAnnotation != null);
            Class<? extends APIObject> internalType = internalTypeAnnotation.internalType();
            assert (internalType != null);
            InternalName internalNameAnnotation = externalField.getAnnotation(InternalName.class);
            String internalName = null;
            internalName = internalNameAnnotation != null ? internalNameAnnotation.value() : externalField.getName();
            Field internalField = ETSoapObject.getField(internalType, internalName);
            XmlElement element = internalField.getAnnotation(XmlElement.class);
            if (element != null) {
                internalProperty = element.name();
            } else {
                XmlElementRef elementRef = internalField.getAnnotation(XmlElementRef.class);
                if (elementRef != null) {
                    internalProperty = elementRef.name();
                }
            }
        }
        return internalProperty;
    }

    protected static java.util.List<String> getInternalProperties(Class<? extends ETSoapObject> type) throws ETSdkException {
        ArrayList<String> internalProperties = new ArrayList<String>();
        Class<? extends ETSoapObject> externalType = type;
        SoapObject internalTypeAnnotation = externalType.getAnnotation(SoapObject.class);
        assert (internalTypeAnnotation != null);
        Class<? extends APIObject> internalType = internalTypeAnnotation.internalType();
        assert (internalType != null);
        java.util.List<Field> externalFields = ETSoapObject.getAllFields(externalType);
        for (Field externalField : externalFields) {
            ExternalName externalName = externalField.getAnnotation(ExternalName.class);
            if (externalName == null) continue;
            String internalProperty = ETSoapObject.getInternalProperty(externalType, externalField.getName());
            assert (internalProperty != null);
            internalProperties.add(internalProperty);
        }
        return internalProperties;
    }

    public static FilterPart toFilterPart(ETExpression expression) {
        ETExpression.Operator operator = expression.getOperator();
        if (operator == null) {
            return null;
        }
        if (operator == ETExpression.Operator.AND || operator == ETExpression.Operator.OR) {
            java.util.List<ETExpression> subexpressions = expression.getSubexpressions();
            ComplexFilterPart complexFilterPart = new ComplexFilterPart();
            complexFilterPart.setLeftOperand(ETSoapObject.toFilterPart(subexpressions.get(0)));
            if (operator == ETExpression.Operator.AND) {
                complexFilterPart.setLogicalOperator(LogicalOperators.AND);
            } else if (operator == ETExpression.Operator.OR) {
                complexFilterPart.setLogicalOperator(LogicalOperators.OR);
            }
            complexFilterPart.setRightOperand(ETSoapObject.toFilterPart(subexpressions.get(1)));
            return complexFilterPart;
        }
        String property = expression.getProperty();
        java.util.List<String> values = expression.getValues();
        SimpleFilterPart simpleFilterPart = new SimpleFilterPart();
        simpleFilterPart.setProperty(property);
        switch (operator) {
            case EQUALS: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.EQUALS);
                break;
            }
            case NOT_EQUALS: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.NOT_EQUALS);
                break;
            }
            case LESS_THAN: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUALS: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.LESS_THAN_OR_EQUAL);
                break;
            }
            case GREATER_THAN: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUALS: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.GREATER_THAN_OR_EQUAL);
                break;
            }
            case IS_NULL: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.IS_NULL);
                break;
            }
            case IS_NOT_NULL: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.IS_NOT_NULL);
                break;
            }
            case BETWEEN: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.BETWEEN);
                break;
            }
            case IN: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.IN);
                break;
            }
            case LIKE: {
                simpleFilterPart.setSimpleOperator(SimpleOperators.LIKE);
                break;
            }
        }
        for (String value : values) {
            simpleFilterPart.getValue().add(value);
        }
        return simpleFilterPart;
    }

    public class EnumConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            return Enum.valueOf(type, value.toString());
        }
    }

    public class DataExtensionRowConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            if (type == Map.class) {
                ObjectExtension.Properties properties = (ObjectExtension.Properties)value;
                HashMap<String, String> columns = new HashMap<String, String>();
                for (APIProperty property : properties.getProperty()) {
                    columns.put(property.getName(), property.getValue());
                }
                return columns;
            }
            if (type == ObjectExtension.Properties.class) {
                Map columns = (Map)value;
                ObjectExtension.Properties properties = new ObjectExtension.Properties();
                for (String key : columns.keySet()) {
                    APIProperty property = new APIProperty();
                    property.setName(key);
                    property.setValue((String)columns.get(key));
                    properties.getProperty().add(property);
                }
                return properties;
            }
            return value;
        }
    }

    public class InternalObjectConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            APIObject internalObject = null;
            try {
                internalObject = ((ETSoapObject)value).toInternal();
            }
            catch (ETSdkException ex) {
                throw new ConversionException("could not convert object", (Throwable)ex);
            }
            return internalObject;
        }
    }

    public class ExternalObjectConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            ETSoapObject externalObject = null;
            try {
                externalObject = (ETSoapObject)type.newInstance();
            }
            catch (Exception ex) {
                throw new ConversionException("could not convert object", (Throwable)ex);
            }
            try {
                externalObject.fromInternal((APIObject)value);
            }
            catch (ETSdkException ex) {
                throw new ConversionException("could not convert object", (Throwable)ex);
            }
            return externalObject;
        }
    }
}

