/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.server;

import com.github.searls.jasmine.config.JasmineConfiguration;
import com.github.searls.jasmine.io.RelativizesFilePaths;
import com.github.searls.jasmine.mojo.Context;
import com.github.searls.jasmine.runner.CreatesRunner;
import com.github.searls.jasmine.server.JasmineResourceHandler;
import com.github.searls.jasmine.thirdpartylibs.ClassPathResourceHandler;
import com.github.searls.jasmine.thirdpartylibs.WebJarResourceHandler;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class ResourceHandlerConfigurator {
    private final JasmineConfiguration configuration;
    private final RelativizesFilePaths relativizesFilePaths;
    private final CreatesRunner createsRunner;

    public ResourceHandlerConfigurator(JasmineConfiguration configuration, RelativizesFilePaths relativizesFilePaths, CreatesRunner createsRunner) {
        this.configuration = configuration;
        this.relativizesFilePaths = relativizesFilePaths;
        this.createsRunner = createsRunner;
    }

    public Handler createHandler() throws IOException {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        for (Context context : this.configuration.getContexts()) {
            String contextRoot = StringUtils.prependIfMissing((String)context.getContextRoot(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            ContextHandler handler = contexts.addContext(contextRoot, "");
            handler.setAliases(true);
            handler.setHandler((Handler)this.createResourceHandler(true, context.getDirectory().getCanonicalPath(), null));
        }
        ContextHandler rootContextHandler = contexts.addContext("/", "");
        rootContextHandler.setHandler((Handler)this.createResourceHandler(false, this.configuration.getBasedir().getCanonicalPath(), new String[]{this.getWelcomeFilePath()}));
        rootContextHandler.setAliases(true);
        ContextHandler classPathContextHandler = contexts.addContext("/classpath", "");
        classPathContextHandler.setHandler((Handler)new ClassPathResourceHandler(this.configuration.getProjectClassLoader()));
        classPathContextHandler.setAliases(true);
        ContextHandler webJarsContextHandler = contexts.addContext("/webjars", "");
        webJarsContextHandler.setHandler((Handler)new WebJarResourceHandler(this.configuration.getProjectClassLoader()));
        webJarsContextHandler.setAliases(true);
        return contexts;
    }

    private ResourceHandler createResourceHandler(boolean directory, String absolutePath, String[] welcomeFiles) {
        JasmineResourceHandler resourceHandler = new JasmineResourceHandler(this.createsRunner, this.configuration);
        resourceHandler.setDirectoriesListed(directory);
        if (welcomeFiles != null) {
            resourceHandler.setWelcomeFiles(welcomeFiles);
        }
        resourceHandler.setResourceBase(absolutePath);
        return resourceHandler;
    }

    private String getWelcomeFilePath() throws IOException {
        return this.relativizesFilePaths.relativize(this.configuration.getBasedir(), this.configuration.getJasmineTargetDir()) + File.separator + this.createsRunner.getRunnerFile();
    }
}

