/*
 * Decompiled with CFR 0.152.
 */
package redis;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import redis.Command;
import redis.reply.BulkReply;
import redis.reply.ErrorReply;
import redis.reply.IntegerReply;
import redis.reply.MultiBulkReply;
import redis.reply.Reply;
import redis.reply.StatusReply;

public class RedisProtocol {
    public static final char CR = '\r';
    public static final char LF = '\n';
    private static final char ZERO = '0';
    private final BufferedInputStream is;
    private final OutputStream os;

    public RedisProtocol(Socket socket) throws IOException {
        this.is = new BufferedInputStream(socket.getInputStream());
        this.os = new BufferedOutputStream(socket.getOutputStream());
    }

    public RedisProtocol(BufferedInputStream is, OutputStream os) {
        this.is = is;
        this.os = os;
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        int total;
        int read;
        long size = RedisProtocol.readLong(is);
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
        }
        if (size == -1L) {
            return null;
        }
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        byte[] bytes = new byte[(int)size];
        int length = bytes.length;
        for (total = 0; total < length && (read = is.read(bytes, total, length - total)) != -1; total += read) {
        }
        if (total < length) {
            throw new IOException("Failed to read enough bytes: " + total);
        }
        int cr = is.read();
        int lf = is.read();
        if (cr != 13 || lf != 10) {
            throw new IOException("Improper line ending: " + cr + ", " + lf);
        }
        return bytes;
    }

    public static long readLong(InputStream is) throws IOException {
        int sign;
        int read = is.read();
        if (read == 45) {
            read = is.read();
            sign = -1;
        } else {
            sign = 1;
        }
        long number = 0L;
        while (true) {
            if (read == -1) {
                throw new EOFException("Unexpected end of stream");
            }
            if (read == 13 && is.read() == 10) {
                return number * (long)sign;
            }
            int value = read - 48;
            if (value >= 0 && value < 10) {
                number *= 10L;
                number += (long)value;
            } else {
                throw new IOException("Invalid character in integer");
            }
            read = is.read();
        }
    }

    public static Reply receive(InputStream is) throws IOException {
        int code = is.read();
        if (code == -1) {
            throw new EOFException();
        }
        switch (code) {
            case 43: {
                return new StatusReply(new DataInputStream(is).readLine());
            }
            case 45: {
                return new ErrorReply(new DataInputStream(is).readLine());
            }
            case 58: {
                return new IntegerReply(RedisProtocol.readLong(is));
            }
            case 36: {
                return new BulkReply(RedisProtocol.readBytes(is));
            }
            case 42: {
                return new MultiBulkReply(is);
            }
        }
        throw new IOException("Unexpected character in stream: " + code);
    }

    public static byte[] toBytes(Number length) {
        return length.toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply receiveAsync() throws IOException {
        BufferedInputStream bufferedInputStream = this.is;
        synchronized (bufferedInputStream) {
            return RedisProtocol.receive(this.is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsync(Command command) throws IOException {
        OutputStream outputStream = this.os;
        synchronized (outputStream) {
            command.write(this.os);
        }
        this.os.flush();
    }

    public void close() throws IOException {
        this.is.close();
        this.os.close();
    }
}

