/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.github.timurstrekalov.saga.core.CoverageGenerator;
import com.github.timurstrekalov.saga.core.DefaultCoverageGenerator;
import com.google.common.reflect.Reflection;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoverageGeneratorFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCoverageGenerator.class);

    public static CoverageGenerator newInstance(String baseDir, File outputDir) {
        final DefaultCoverageGenerator delegate = new DefaultCoverageGenerator();
        delegate.getConfig().setBaseDir(baseDir);
        delegate.getConfig().setOutputDir(outputDir);
        return (CoverageGenerator)Reflection.newProxy(CoverageGenerator.class, (InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().startsWith("set")) {
                    logger.debug("{}({})", (Object)method.getName(), (Object)Arrays.toString(args));
                }
                return method.invoke((Object)delegate, args);
            }
        });
    }
}

