/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.gargoylesoftware.htmlunit.JavaScriptPage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.github.timurstrekalov.saga.core.Config;
import com.github.timurstrekalov.saga.core.CoverageGenerator;
import com.github.timurstrekalov.saga.core.FileStats;
import com.github.timurstrekalov.saga.core.FileSystemSourcePreloader;
import com.github.timurstrekalov.saga.core.HtmlUnitUtil;
import com.github.timurstrekalov.saga.core.InstanceFieldPerPropertyConfig;
import com.github.timurstrekalov.saga.core.OutputStrategy;
import com.github.timurstrekalov.saga.core.ReportFormat;
import com.github.timurstrekalov.saga.core.RunStats;
import com.github.timurstrekalov.saga.core.ScriptData;
import com.github.timurstrekalov.saga.core.ScriptInstrumenter;
import com.github.timurstrekalov.saga.core.TestFetcher;
import com.github.timurstrekalov.saga.core.TestFetcherFactory;
import com.github.timurstrekalov.saga.core.UriUtil;
import com.github.timurstrekalov.saga.core.WebClientFactory;
import com.github.timurstrekalov.saga.core.reporter.CsvReporter;
import com.github.timurstrekalov.saga.core.reporter.HtmlReporter;
import com.github.timurstrekalov.saga.core.reporter.PdfReporter;
import com.github.timurstrekalov.saga.core.reporter.RawReporter;
import com.github.timurstrekalov.saga.core.reporter.Reporter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCoverageGenerator
implements CoverageGenerator {
    private static final String COVERAGE_VARIABLE_NAME = "__coverage_data";
    private static final String TOTAL_REPORT_NAME = "total";
    private static final String INSTRUMENTED_FILE_DIRECTORY_NAME = "instrumented";
    private static final String INLINE_SCRIPT_RE = ".+__from_\\d+_\\d+_to_\\d+_\\d+$";
    private static final Logger logger = LoggerFactory.getLogger(DefaultCoverageGenerator.class);
    private static final Map<ReportFormat, Class<? extends Reporter>> reporters = ImmutableMap.builder().put((Object)ReportFormat.HTML, HtmlReporter.class).put((Object)ReportFormat.RAW, RawReporter.class).put((Object)ReportFormat.CSV, CsvReporter.class).put((Object)ReportFormat.PDF, PdfReporter.class).build();
    private static final ThreadLocal<WebClient> localClient = new ThreadLocal();
    private final Config config = new InstanceFieldPerPropertyConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void instrumentAndGenerateReports() throws IOException {
        Preconditions.checkNotNull((Object)this.config.getBaseDir(), (Object)"baseDir cannot be null");
        Preconditions.checkNotNull((Object)this.config.getOutputDir(), (Object)"outputDir cannot be null");
        URI baseUri = this.config.getBaseUri();
        List<URI> tests = this.fetchTests(baseUri);
        if (tests.isEmpty()) {
            logger.warn("No tests found, exiting");
            return;
        }
        int actualThreadCount = Math.min(this.config.getThreadCount(), tests.size());
        logger.info("Using up to {} threads", (Object)actualThreadCount);
        final OutputStrategy outputStrategy = this.config.getOutputStrategy();
        logger.info("Output strategy set to {}", (Object)outputStrategy);
        if (!this.config.isIncludeInlineScripts()) {
            this.config.getNoInstrumentPatterns().add(INLINE_SCRIPT_RE);
            this.config.getNoInstrumentPatterns().add(".+JavaScriptStringJob");
            this.config.getNoInstrumentPatterns().add(".+#\\d+\\(eval\\)\\(\\d+\\)");
        }
        if (!this.config.getNoInstrumentPatterns().isEmpty()) {
            logger.info("Using the following no-instrument patterns:\n\t{}", (Object)StringUtils.join(this.config.getNoInstrumentPatterns(), (String)"\n\t"));
        }
        File outputDir = this.config.getOutputDir();
        FileUtils.mkdir((String)outputDir.getAbsolutePath());
        final Collection<Pattern> ignorePatterns = this.createPatterns();
        final File instrumentedFileDirectory = new File(outputDir, INSTRUMENTED_FILE_DIRECTORY_NAME);
        RunStats totalStats = new RunStats(baseUri.relativize(URI.create(TOTAL_REPORT_NAME)), "Total coverage report");
        totalStats.setSortBy(this.config.getSortBy());
        totalStats.setOrder(this.config.getOrder());
        this.maybePreloadSources(ignorePatterns, instrumentedFileDirectory, totalStats);
        ExecutorService executorService = Executors.newFixedThreadPool(actualThreadCount);
        ExecutorCompletionService<RunStats> completionService = new ExecutorCompletionService<RunStats>(executorService);
        for (final URI test : tests) {
            completionService.submit(new Callable<RunStats>(){

                @Override
                public RunStats call() {
                    logger.info("Running test at {}", (Object)test.toString());
                    try {
                        RunStats runStats = DefaultCoverageGenerator.this.runTest(test, ignorePatterns, instrumentedFileDirectory);
                        if (runStats == RunStats.EMPTY) {
                            logger.warn("No actual test run for file: {}", (Object)test);
                        } else if (outputStrategy.contains(OutputStrategy.PER_TEST)) {
                            if (UriUtil.isFileUri(test)) {
                                DefaultCoverageGenerator.this.writeRunStats(runStats);
                            } else {
                                logger.warn("Output strategy PER_TEST only makes sense in the context of tests run off the filesystem, ignoring");
                            }
                        }
                        return runStats;
                    }
                    catch (IOException e) {
                        return RunStats.EMPTY;
                    }
                }
            });
        }
        LinkedList allRunStats = Lists.newLinkedList();
        try {
            for (URI test : tests) {
                try {
                    Future future = completionService.take();
                    RunStats runStats = (RunStats)future.get();
                    allRunStats.add(runStats);
                }
                catch (Exception e) {
                    logger.warn("Error running test {}: {}", (Object)test.toString(), (Object)e.getMessage());
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            executorService.shutdown();
        }
        logger.info("Test run finished");
        if (outputStrategy.contains(OutputStrategy.TOTAL)) {
            for (RunStats runStats : allRunStats) {
                if (runStats == RunStats.EMPTY) continue;
                for (FileStats fileStats : runStats) {
                    totalStats.add(fileStats);
                }
            }
            this.writeRunStats(totalStats);
        }
    }

    private void maybePreloadSources(Collection<Pattern> ignorePatterns, File instrumentedFileDirectory, RunStats totalStats) throws IOException {
        ScriptInstrumenter instrumenter = this.newInstrumenter(ignorePatterns, instrumentedFileDirectory, this.getThreadLocalWebClient().getJavaScriptEngine().getContextFactory());
        new FileSystemSourcePreloader().preloadSources(this.config, instrumenter, totalStats);
    }

    private Collection<Pattern> createPatterns() {
        return Collections2.transform(this.config.getNoInstrumentPatterns(), (Function)new Function<String, Pattern>(){

            public Pattern apply(String input) {
                return Pattern.compile(input);
            }
        });
    }

    private RunStats runTest(URI test, Collection<Pattern> ignorePatterns, File instrumentedFileDirectory) throws IOException {
        HtmlPage htmlPage;
        WebClient client = this.getThreadLocalWebClient();
        ScriptInstrumenter instrumenter = this.newInstrumenter(ignorePatterns, instrumentedFileDirectory, client.getJavaScriptEngine().getContextFactory());
        client.setScriptPreProcessor((ScriptPreProcessor)instrumenter);
        Page page = client.getPage(test.toURL());
        if (page instanceof HtmlPage) {
            htmlPage = (HtmlPage)page;
        } else if (page instanceof JavaScriptPage) {
            JavaScriptPage javaScriptPage = (JavaScriptPage)page;
            WebResponse webResponse = javaScriptPage.getWebResponse();
            htmlPage = new HtmlPage(javaScriptPage.getUrl(), webResponse, javaScriptPage.getEnclosingWindow());
            client.getJavaScriptEngine().execute(htmlPage, webResponse.getContentAsString(), test.toString(), 1);
        } else {
            throw new RuntimeException("Unsupported page type: " + page.getUrl() + " (of class " + page.getClass() + ")");
        }
        return this.collectAndRunStats(client, htmlPage, test, instrumenter);
    }

    private ScriptInstrumenter newInstrumenter(Collection<Pattern> ignorePatterns, File instrumentedFileDirectory, HtmlUnitContextFactory contextFactory) {
        ScriptInstrumenter instrumenter = new ScriptInstrumenter(this.config, contextFactory, COVERAGE_VARIABLE_NAME);
        instrumenter.setIgnorePatterns(ignorePatterns);
        if (this.config.isOutputInstrumentedFiles()) {
            FileUtils.mkdir((String)instrumentedFileDirectory.getAbsolutePath());
            instrumenter.setInstrumentedFileDirectory(instrumentedFileDirectory);
        }
        return instrumenter;
    }

    private RunStats collectAndRunStats(WebClient client, HtmlPage htmlPage, URI test, ScriptInstrumenter instrumenter) throws IOException {
        client.waitForBackgroundJavaScript(this.config.getBackgroundJavaScriptTimeout());
        client.setScriptPreProcessor(null);
        Object javaScriptResult = htmlPage.executeJavaScript("window.__coverage_data").getJavaScriptResult();
        if (!(javaScriptResult instanceof Undefined)) {
            return this.collectAndWriteRunStats(test, instrumenter, (NativeObject)javaScriptResult);
        }
        return RunStats.EMPTY;
    }

    private RunStats collectAndWriteRunStats(URI test, ScriptInstrumenter instrumenter, NativeObject allCoverageData) throws IOException {
        RunStats runStats = new RunStats(test);
        runStats.setSortBy(this.config.getSortBy());
        runStats.setOrder(this.config.getOrder());
        for (ScriptData data : instrumenter.getScriptDataList()) {
            Map coverageData = (Map)allCoverageData.get((Object)data.getSourceUriAsString());
            FileStats fileStats = data.generateFileStats(this.config.getBaseUri(), coverageData);
            runStats.add(fileStats);
        }
        return runStats;
    }

    private void writeRunStats(RunStats stats) throws IOException {
        for (ReportFormat reportFormat : this.config.getReportFormats()) {
            this.reporterFor(reportFormat).writeReport(this.config.getBaseUri(), this.config.getOutputDir(), stats);
        }
    }

    private Reporter reporterFor(ReportFormat reportFormat) {
        if (!reporters.containsKey((Object)reportFormat)) {
            throw new IllegalStateException("Missing reporter for format: " + (Object)((Object)reportFormat));
        }
        try {
            return reporters.get((Object)reportFormat).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    private WebClient getThreadLocalWebClient() {
        if (localClient.get() == null) {
            localClient.set(WebClientFactory.newInstance(this.config));
        }
        return localClient.get();
    }

    private List<URI> fetchTests(URI baseDir) throws IOException {
        TestFetcher fetcher = TestFetcherFactory.newInstance(baseDir);
        List<URI> tests = fetcher.fetch(baseDir, this.config.getIncludes(), this.config.getExcludes());
        logger.info("{} tests found", (Object)tests.size());
        return tests;
    }

    static {
        HtmlUnitUtil.silenceHtmlUnitLogging();
    }
}

