/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.github.timurstrekalov.saga.core.TestFetcher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;

class FileSystemTestFetcher
implements TestFetcher {
    FileSystemTestFetcher() {
    }

    @Override
    public List<URI> fetch(URI baseUri, String includes, String excludes) throws IOException {
        File baseDir = new File(baseUri);
        Preconditions.checkState((boolean)baseDir.exists(), (Object)"baseDir doesn't exist");
        List tests = FileUtils.getFiles((File)baseDir, (String)includes, (String)excludes);
        return ImmutableList.copyOf((Collection)Lists.transform((List)tests, (Function)new Function<File, URI>(){

            public URI apply(File input) {
                return input.toURI();
            }
        }));
    }
}

