/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

class LineCoverageRecord {
    private int lineNr;
    private int timesExecuted;
    private String line;

    LineCoverageRecord(int lineNr, int timesExecuted, String line) {
        this.lineNr = lineNr;
        this.timesExecuted = timesExecuted;
        this.line = line;
    }

    public static LineCoverageRecord merge(LineCoverageRecord l1, LineCoverageRecord l2) {
        Preconditions.checkArgument((l1.lineNr == l2.lineNr ? 1 : 0) != 0, (String)"Got different line numbers: %d  and %d", (Object[])new Object[]{l1.lineNr, l2.lineNr});
        Preconditions.checkArgument((boolean)l1.line.equals(l2.line), (String)"Got different lines: %d and %d", (Object[])new Object[]{l1.line, l2.line});
        return new LineCoverageRecord(l1.lineNr, l1.timesExecuted == -1 ? -1 : l1.timesExecuted + l2.timesExecuted, l1.line);
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public int getTimesExecuted() {
        return this.timesExecuted;
    }

    public String getLineSource() {
        return StringEscapeUtils.escapeHtml((String)StringEscapeUtils.escapeJavaScript((String)this.line));
    }

    public boolean isExecutable() {
        return this.timesExecuted > -1;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("lineNr", this.lineNr).append("timesExecuted", this.timesExecuted).append("line", (Object)this.line).toString();
    }
}

