/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import java.io.File;
import java.net.URI;

final class MiscUtil {
    private static final int[] red = new int[]{219, 75, 75};
    private static final int[] yellow = new int[]{219, 219, 75};
    private static final int[] green = new int[]{174, 219, 75};

    private MiscUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    static int toCoverage(int totalStatements, int totalExecuted) {
        return (int)((double)totalExecuted / (double)totalStatements * 100.0);
    }

    static <T> int sum(Iterable<T> objects, Function<T, Integer> transformer) {
        int sum = 0;
        for (T t : objects) {
            sum += ((Integer)transformer.apply(t)).intValue();
        }
        return sum;
    }

    static String getColor(int coverage) {
        int color = MiscUtil.getColorAsArgb(coverage);
        return Joiner.on((String)", ").join((Object)(color >> 16 & 0xFF), (Object)(color >> 8 & 0xFF), new Object[]{color & 0xFF});
    }

    static int getColorAsArgb(int coverage) {
        int[] from = coverage < 50 ? red : yellow;
        int[] to = coverage < 50 ? yellow : green;
        double prc = (double)(coverage - (coverage < 50 ? 0 : 50)) / 50.0;
        int[] color = new int[3];
        for (int i = 0; i < 3; ++i) {
            color[i] = (int)((double)(to[i] - from[i]) * prc + (double)from[i]);
        }
        return 0xFF000000 | color[0] << 16 | color[1] << 8 | color[2];
    }

    static String getFullSourcePath(HtmlPage htmlPage, String sourceName) {
        try {
            URI sourceUri = URI.create(sourceName.replaceAll(" ", "%20"));
            if (sourceUri.isAbsolute()) {
                return new File(URI.create(sourceUri.getScheme() + "://" + sourceUri.getPath())).getAbsolutePath();
            }
            URI uri = htmlPage.getUrl().toURI();
            URI pageUriWithoutQuery = URI.create(uri.getScheme() + "://" + uri.getPath());
            return new File(new File(pageUriWithoutQuery).getParent(), URI.create(sourceName).getPath()).getAbsolutePath();
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting full path for " + sourceName + " at " + htmlPage.getUrl(), e);
        }
    }
}

