/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuietJavaScriptErrorListener
implements JavaScriptErrorListener {
    private static final Logger logger = LoggerFactory.getLogger(QuietJavaScriptErrorListener.class);

    QuietJavaScriptErrorListener() {
    }

    public void scriptException(HtmlPage htmlPage, ScriptException e) {
        logger.error("Script exception on page {}, message: {}, failing line: {}", new Object[]{htmlPage.getUrl(), e.getMessage(), e.getFailingLine()});
        logger.debug(e.getMessage(), (Throwable)e);
    }

    public void timeoutError(HtmlPage htmlPage, long allowedTime, long executionTime) {
        logger.error("Timeout error on page {}. Allowed time: {}, execution time: {}", new Object[]{htmlPage.getUrl(), allowedTime, executionTime});
    }

    public void malformedScriptURL(HtmlPage htmlPage, String url, MalformedURLException e) {
        logger.error("Malformed script URL on page {}. URL: {}, message: {}", new Object[]{htmlPage.getUrl(), url, e.getMessage()});
        logger.debug(e.getMessage(), (Throwable)e);
    }

    public void loadScriptError(HtmlPage htmlPage, URL scriptUrl, Exception e) {
        logger.warn("Error loading script referenced on page {}. Script URL: {}, message: {}", new Object[]{htmlPage.getUrl(), scriptUrl, e.getMessage()});
        logger.debug(e.getMessage(), (Throwable)e);
    }
}

