/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.github.timurstrekalov.saga.core.FileStats;
import com.github.timurstrekalov.saga.core.MiscUtil;
import com.github.timurstrekalov.saga.core.Order;
import com.github.timurstrekalov.saga.core.SortBy;
import com.github.timurstrekalov.saga.core.UriUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RunStats
implements Iterable<FileStats> {
    public static final RunStats EMPTY = new RunStats(null, null);
    public final URI test;
    public final String title;
    private SortBy sortBy = SortBy.COVERAGE;
    private Order order = Order.ASC;
    private final Map<URI, FileStats> fileStatsMap = Maps.newTreeMap();

    public RunStats(URI test) {
        this(test, String.format("Coverage report for \"%s\"", test));
    }

    public RunStats(URI test, String title) {
        this.test = test;
        this.title = title;
    }

    public String getTestName() {
        return UriUtil.getLastSegmentOrHost(this.test);
    }

    void add(FileStats newStats) {
        URI key = newStats.getFileUri();
        FileStats oldStats = this.fileStatsMap.get(key);
        if (oldStats != null) {
            this.fileStatsMap.put(key, FileStats.merge(newStats, oldStats));
        } else {
            this.fileStatsMap.put(key, newStats);
        }
    }

    public List<FileStats> getFileStats() {
        LinkedList result = Lists.newLinkedList(this.fileStatsMap.values());
        Collections.sort(result, new Comparator<FileStats>(){

            @Override
            public int compare(FileStats s1, FileStats s2) {
                return (RunStats.this.getOrder() == Order.ASC ? 1 : -1) * RunStats.this.getSortBy().compare(s1, s2);
            }
        });
        return result;
    }

    public Collection<FileStats> getFileStatsWithSeparateFileOnly() {
        return Collections2.filter(this.getFileStats(), (Predicate)new Predicate<FileStats>(){

            public boolean apply(FileStats stats) {
                return stats.isSeparateFile();
            }
        });
    }

    public int getTotalStatements() {
        return MiscUtil.sum(this.fileStatsMap.values(), new Function<FileStats, Integer>(){

            public Integer apply(FileStats input) {
                return input.getStatements();
            }
        });
    }

    public int getTotalExecuted() {
        return MiscUtil.sum(this.fileStatsMap.values(), new Function<FileStats, Integer>(){

            public Integer apply(FileStats input) {
                return input.getExecuted();
            }
        });
    }

    public int getTotalCoverage() {
        return MiscUtil.toCoverage(this.getTotalStatements(), this.getTotalExecuted());
    }

    public boolean getHasStatements() {
        return this.getTotalStatements() > 0;
    }

    public String getBarColor() {
        return MiscUtil.getColor(this.getTotalCoverage());
    }

    public int getBarColorAsArgb() {
        return MiscUtil.getColorAsArgb(this.getTotalCoverage());
    }

    @Override
    public Iterator<FileStats> iterator() {
        return this.getFileStats().iterator();
    }

    public void setSortBy(SortBy sortBy) {
        if (sortBy == null) {
            return;
        }
        this.sortBy = sortBy;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public void setOrder(Order order) {
        if (order == null) {
            return;
        }
        this.order = order;
    }

    public Order getOrder() {
        return this.order;
    }
}

