/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.github.timurstrekalov.saga.core.FileStats;
import com.github.timurstrekalov.saga.core.LineCoverageRecord;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

class ScriptData {
    private final URI sourceUri;
    private final String sourceCode;
    private final boolean separateFile;
    private final Map<Integer, Integer> statementsWithLengths = Maps.newTreeMap();
    private String instrumentedSourceCode;

    ScriptData(URI sourceUri, String sourceCode, boolean separateFile) {
        this.sourceUri = sourceUri;
        this.sourceCode = sourceCode;
        this.separateFile = separateFile;
    }

    void addExecutableLine(Integer lineNr, Integer length) {
        this.statementsWithLengths.put(lineNr, length);
    }

    public URI getSourceUri() {
        return this.sourceUri;
    }

    public String getSourceUriAsString() {
        return this.sourceUri.toString();
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public Set<Integer> getLineNumbersOfAllStatements() {
        return this.statementsWithLengths.keySet();
    }

    public int getNumberOfStatements() {
        return this.statementsWithLengths.size();
    }

    public boolean hasStatement(int lineNr) {
        return this.statementsWithLengths.containsKey(lineNr);
    }

    public Integer getStatementLength(int lineNr) {
        return this.statementsWithLengths.get(lineNr);
    }

    public int getLineNumberOfFirstStatement() {
        return this.getLineNumbersOfAllStatements().iterator().next();
    }

    public void setInstrumentedSourceCode(String instrumentedSourceCode) {
        this.instrumentedSourceCode = instrumentedSourceCode;
    }

    public String getInstrumentedSourceCode() {
        return this.instrumentedSourceCode;
    }

    public boolean isSeparateFile() {
        return this.separateFile;
    }

    public FileStats generateFileStats(URI baseUri, Map<Integer, Double> coverageData) {
        Scanner in = new Scanner(this.getSourceCode());
        ArrayList lineCoverageRecords = Lists.newArrayList();
        if (!this.getLineNumbersOfAllStatements().isEmpty()) {
            int lineNr;
            for (lineNr = 1; lineNr < this.getLineNumberOfFirstStatement() && in.hasNext(); ++lineNr) {
                lineCoverageRecords.add(new LineCoverageRecord(lineNr, -1, in.nextLine()));
            }
            lineNr = this.getLineNumberOfFirstStatement();
            int lengthCountdown = 0;
            while (in.hasNext()) {
                int timesLineExecuted;
                String line = in.nextLine();
                Double coverageEntry = coverageData.get(lineNr);
                if (coverageEntry == null) {
                    int lineLength = line.trim().length();
                    if (lengthCountdown > 0 && lineLength > 0) {
                        lengthCountdown -= lineLength;
                        timesLineExecuted = -1;
                    } else {
                        timesLineExecuted = this.hasStatement(lineNr) ? 0 : -1;
                    }
                } else {
                    timesLineExecuted = coverageEntry.intValue();
                    if (this.getStatementLength(lineNr) != null) {
                        lengthCountdown = this.getStatementLength(lineNr);
                    }
                }
                lineCoverageRecords.add(new LineCoverageRecord(lineNr, timesLineExecuted, line));
                ++lineNr;
            }
        } else {
            int lineNr = 1;
            while (in.hasNext()) {
                lineCoverageRecords.add(new LineCoverageRecord(lineNr, -1, in.nextLine()));
                ++lineNr;
            }
        }
        return new FileStats(baseUri, this.getSourceUri(), lineCoverageRecords, this.isSeparateFile());
    }
}

