/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.github.timurstrekalov.saga.core.Config;
import com.github.timurstrekalov.saga.core.ScriptData;
import com.github.timurstrekalov.saga.core.UriUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.CompilerEnvirons;
import net.sourceforge.htmlunit.corejs.javascript.Node;
import net.sourceforge.htmlunit.corejs.javascript.Parser;
import net.sourceforge.htmlunit.corejs.javascript.ast.AstNode;
import net.sourceforge.htmlunit.corejs.javascript.ast.AstRoot;
import net.sourceforge.htmlunit.corejs.javascript.ast.Block;
import net.sourceforge.htmlunit.corejs.javascript.ast.ElementGet;
import net.sourceforge.htmlunit.corejs.javascript.ast.ExpressionStatement;
import net.sourceforge.htmlunit.corejs.javascript.ast.IfStatement;
import net.sourceforge.htmlunit.corejs.javascript.ast.LabeledStatement;
import net.sourceforge.htmlunit.corejs.javascript.ast.Loop;
import net.sourceforge.htmlunit.corejs.javascript.ast.Name;
import net.sourceforge.htmlunit.corejs.javascript.ast.NodeVisitor;
import net.sourceforge.htmlunit.corejs.javascript.ast.NumberLiteral;
import net.sourceforge.htmlunit.corejs.javascript.ast.StringLiteral;
import net.sourceforge.htmlunit.corejs.javascript.ast.SwitchCase;
import net.sourceforge.htmlunit.corejs.javascript.ast.UnaryExpression;
import net.sourceforge.htmlunit.corejs.javascript.ast.VariableDeclaration;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScriptInstrumenter
implements ScriptPreProcessor {
    private static final AtomicInteger evalCounter = new AtomicInteger();
    private static final Logger logger;
    private static final Pattern inlineScriptRe;
    private static final Pattern evalRe;
    private static final Pattern nonFileRe;
    private static final ConcurrentMap<URI, ScriptData> instrumentedScriptCache;
    private static final ConcurrentHashMultiset<URI> writtenToDisk;
    private final HtmlUnitContextFactory contextFactory;
    private final String coverageVariableName;
    private final String initializingCode;
    private final String arrayInitializer;
    private final Config config;
    private final List<ScriptData> scriptDataList = Lists.newLinkedList();
    private Collection<Pattern> ignorePatterns;
    private File instrumentedFileDirectory;

    public ScriptInstrumenter(Config config, HtmlUnitContextFactory contextFactory, String coverageVariableName) {
        this.config = config;
        this.contextFactory = contextFactory;
        this.coverageVariableName = coverageVariableName;
        this.initializingCode = String.format("%s = window.%s || {};%n", coverageVariableName, coverageVariableName);
        this.arrayInitializer = String.format("%s['%%s'][%%d] = 0;%n", coverageVariableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String preProcess(HtmlPage htmlPage, String sourceCode, String sourceName, int lineNumber, HtmlElement htmlElement) {
        try {
            String normalizedSourceName = this.handleEvals(this.handleInlineScripts(sourceName));
            if (this.shouldIgnore(normalizedSourceName)) {
                return sourceCode;
            }
            boolean separateFile = this.isSeparateFile(sourceName, normalizedSourceName);
            URI sourceUri = URI.create(normalizedSourceName).normalize();
            if (this.config.isCacheInstrumentedCode() && instrumentedScriptCache.containsKey(sourceUri)) {
                ScriptData data = (ScriptData)instrumentedScriptCache.get(sourceUri);
                this.scriptDataList.add(data);
                return data.getInstrumentedSourceCode();
            }
            ScriptData data = new ScriptData(sourceUri, sourceCode, separateFile);
            this.scriptDataList.add(data);
            CompilerEnvirons environs = new CompilerEnvirons();
            environs.initFromContext(this.contextFactory.enterContext());
            AstRoot root = new Parser(environs).parse(data.getSourceCode(), data.getSourceUriAsString(), lineNumber);
            root.visit((NodeVisitor)new InstrumentingVisitor(data, lineNumber - 1));
            String treeSource = root.toSource();
            StringBuilder buf = new StringBuilder(this.initializingCode.length() + data.getNumberOfStatements() * this.arrayInitializer.length() + treeSource.length());
            buf.append(this.initializingCode);
            buf.append(String.format("%s['%s'] = {};%n", this.coverageVariableName, this.escapePath(data.getSourceUriAsString())));
            for (Integer i : data.getLineNumbersOfAllStatements()) {
                buf.append(String.format(this.arrayInitializer, this.escapePath(data.getSourceUriAsString()), i));
            }
            buf.append(treeSource);
            String instrumentedCode = buf.toString();
            data.setInstrumentedSourceCode(instrumentedCode);
            if (this.config.isCacheInstrumentedCode()) {
                instrumentedScriptCache.putIfAbsent(sourceUri, data);
            }
            if (this.config.isOutputInstrumentedFiles() && separateFile) {
                ConcurrentHashMultiset<URI> concurrentHashMultiset = writtenToDisk;
                synchronized (concurrentHashMultiset) {
                    try {
                        if (!writtenToDisk.contains((Object)sourceUri)) {
                            String parent = UriUtil.getParent(sourceUri);
                            String fileName = UriUtil.getLastSegmentOrHost(sourceUri);
                            File fileOutputDir = new File(this.instrumentedFileDirectory, Hashing.md5().hashString((CharSequence)parent).toString());
                            FileUtils.mkdir((String)fileOutputDir.getAbsolutePath());
                            File outputFile = new File(fileOutputDir, fileName);
                            logger.info("Writing instrumented file: {}", (Object)outputFile.getAbsolutePath());
                            ByteStreams.write((byte[])instrumentedCode.getBytes("UTF-8"), (OutputSupplier)Files.newOutputStreamSupplier((File)outputFile));
                            writtenToDisk.add((Object)sourceUri);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return instrumentedCode;
        }
        catch (RuntimeException e) {
            logger.error("Exception caught while instrumenting code", (Throwable)e);
            return sourceCode;
        }
    }

    private String escapePath(String path) {
        return path.replaceAll("\\\\", "\\\\\\\\");
    }

    private boolean isSeparateFile(String sourceName, String normalizedSourceName) {
        return normalizedSourceName.equals(sourceName) && !nonFileRe.matcher(normalizedSourceName).matches();
    }

    private String handleInlineScripts(String sourceName) {
        return inlineScriptRe.matcher(sourceName).replaceAll("$1__from_$2_$3_to_$4_$5");
    }

    private String handleEvals(String sourceName) {
        Matcher matcher = evalRe.matcher(sourceName);
        if (matcher.find()) {
            return sourceName + "(" + evalCounter.getAndIncrement() + ")";
        }
        return sourceName;
    }

    private boolean shouldIgnore(final String sourceName) {
        return this.ignorePatterns != null && Iterables.any(this.ignorePatterns, (Predicate)new Predicate<Pattern>(){

            public boolean apply(Pattern input) {
                return input.matcher(sourceName).matches();
            }
        });
    }

    public List<ScriptData> getScriptDataList() {
        return this.scriptDataList;
    }

    public void setIgnorePatterns(Collection<Pattern> ignorePatterns) {
        this.ignorePatterns = ignorePatterns;
    }

    public void setInstrumentedFileDirectory(File instrumentedFileDirectory) {
        this.instrumentedFileDirectory = instrumentedFileDirectory;
    }

    public File getInstrumentedFileDirectory() {
        return this.instrumentedFileDirectory;
    }

    static {
        try {
            Field field = AstNode.class.getDeclaredField("operatorNames");
            field.setAccessible(true);
            Map operatorNames = (Map)field.get(AstNode.class);
            operatorNames.put(126, "void");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger = LoggerFactory.getLogger(ScriptInstrumenter.class);
        inlineScriptRe = Pattern.compile("script in (.+) from \\((\\d+), (\\d+)\\) to \\((\\d+), (\\d+)\\)");
        evalRe = Pattern.compile("(.+)#(\\d+\\(eval\\))");
        nonFileRe = Pattern.compile("JavaScriptStringJob");
        instrumentedScriptCache = Maps.newConcurrentMap();
        writtenToDisk = ConcurrentHashMultiset.create();
    }

    private class InstrumentingVisitor
    implements NodeVisitor {
        private final ScriptData data;
        private final int lineNumberOffset;

        public InstrumentingVisitor(ScriptData data, int lineNumberOffset) {
            this.data = data;
            this.lineNumberOffset = lineNumberOffset;
        }

        public boolean visit(AstNode node) {
            this.handleVoidBug(node);
            this.handleNumberLiteralBug(node);
            if (this.isExecutableBlock(node)) {
                this.addInstrumentationSnippetFor(node);
            }
            return true;
        }

        private void handleVoidBug(AstNode node) {
            AstNode operand;
            if (node.getType() == 126 && (operand = ((UnaryExpression)node).getOperand()).getType() == 40) {
                NumberLiteral numberLiteral = (NumberLiteral)operand;
                numberLiteral.setValue(" " + this.getValue(numberLiteral));
            }
        }

        private void handleNumberLiteralBug(AstNode node) {
            if (node.getType() == 40) {
                NumberLiteral numberLiteral = (NumberLiteral)node;
                numberLiteral.setValue(this.getValue(numberLiteral));
                this.handleVoidBug(node.getParent());
            }
        }

        private String getValue(NumberLiteral literal) {
            if (Math.floor(literal.getNumber()) == literal.getNumber()) {
                return Long.toString((long)literal.getNumber());
            }
            return Double.toString(literal.getNumber());
        }

        private boolean isExecutableBlock(AstNode node) {
            AstNode parent = node.getParent();
            if (parent == null) {
                return false;
            }
            int type = node.getType();
            int parentType = parent.getType();
            return type == 114 || type == 119 || type == 118 || type == 117 || type == 121 || type == 120 || type == 81 || type == 50 || type == 115 || type == 112 || type == 134 || type == 133 || type == 4 || type == 109 && (parentType == 136 || parentType == 129) || type == 122 && node.getClass() == VariableDeclaration.class && parentType != 119;
        }

        private void addInstrumentationSnippetFor(AstNode node) {
            AstNode parent = node.getParent();
            int type = node.getType();
            int parentType = parent.getType();
            if (type == 117 || type == 119 || type == 118) {
                this.fixLoops((Loop)node);
            }
            if (type == 112) {
                this.fixIf((IfStatement)node);
            }
            if (type == 115) {
                this.handleSwitchCase((SwitchCase)node);
            } else if (type == 112 && parentType == 112) {
                IfStatement elseIfStatement = (IfStatement)node;
                IfStatement ifStatement = (IfStatement)parent;
                if (ifStatement.getElsePart() == elseIfStatement) {
                    this.flattenElseIf(elseIfStatement, ifStatement);
                    this.data.addExecutableLine(this.getActualLineNumber(node), node.getLength());
                }
            } else if (parentType != 115) {
                if (parent.getClass() == LabeledStatement.class) {
                    return;
                }
                if (parent.hasChildren()) {
                    parent.addChildBefore((Node)this.newInstrumentationNode(this.getActualLineNumber(node)), (Node)node);
                } else {
                    Block block = this.newInstrumentedBlock(node);
                    if (parentType == 112) {
                        IfStatement ifStatement = (IfStatement)parent;
                        if (ifStatement.getThenPart() == node) {
                            ifStatement.setThenPart((AstNode)block);
                        } else if (ifStatement.getElsePart() == node) {
                            ifStatement.setElsePart((AstNode)block);
                        }
                    } else if (parentType == 117 || parentType == 119 || parentType == 118) {
                        ((Loop)parent).setBody((AstNode)block);
                    } else {
                        logger.warn("Cannot handle node with parent that has no children, parent class: {}, parent source:\n{}", parent.getClass(), (Object)parent.toSource());
                    }
                }
                this.data.addExecutableLine(this.getActualLineNumber(node), node.getLength());
            }
        }

        private void fixLoops(Loop loop) {
            if (loop.getBody().getType() == 128) {
                loop.setBody((AstNode)new Block());
            }
        }

        private void fixIf(IfStatement ifStatement) {
            if (ifStatement.getThenPart().getType() == 128) {
                ifStatement.setThenPart((AstNode)new Block());
            }
        }

        private int getActualLineNumber(AstNode node) {
            return node.getLineno() - this.lineNumberOffset;
        }

        private Block newInstrumentedBlock(AstNode node) {
            Block block = new Block();
            block.addChild(node);
            block.addChildBefore((Node)this.newInstrumentationNode(this.getActualLineNumber(node)), (Node)node);
            return block;
        }

        private void handleSwitchCase(SwitchCase switchCase) {
            if (switchCase.getStatements() == null) {
                return;
            }
            ArrayList newStatements = Lists.newArrayList();
            for (AstNode statement : switchCase.getStatements()) {
                int lineNr = this.getActualLineNumber(statement);
                this.data.addExecutableLine(lineNr, switchCase.getLength());
                newStatements.add(this.newInstrumentationNode(lineNr));
                newStatements.add(statement);
            }
            switchCase.setStatements((List)newStatements);
        }

        private void flattenElseIf(IfStatement elseIfStatement, IfStatement ifStatement) {
            Block block = new Block();
            block.addChild((AstNode)elseIfStatement);
            ifStatement.setElsePart((AstNode)block);
            int lineNr = this.getActualLineNumber((AstNode)elseIfStatement);
            this.data.addExecutableLine(lineNr, elseIfStatement.getLength());
            block.addChildBefore((Node)this.newInstrumentationNode(lineNr), (Node)elseIfStatement);
        }

        private AstNode newInstrumentationNode(int lineNr) {
            ExpressionStatement instrumentationNode = new ExpressionStatement();
            UnaryExpression inc = new UnaryExpression();
            inc.setIsPostfix(true);
            inc.setOperator(106);
            ElementGet outer = new ElementGet();
            ElementGet inner = new ElementGet();
            outer.setTarget((AstNode)inner);
            Name covDataVar = new Name();
            covDataVar.setIdentifier(ScriptInstrumenter.this.coverageVariableName);
            inner.setTarget((AstNode)covDataVar);
            StringLiteral fileName = new StringLiteral();
            fileName.setValue(this.data.getSourceUriAsString());
            fileName.setQuoteCharacter('\'');
            inner.setElement((AstNode)fileName);
            NumberLiteral index = new NumberLiteral();
            index.setNumber((double)lineNr);
            index.setValue(Integer.toString(lineNr));
            outer.setElement((AstNode)index);
            inc.setOperand((AstNode)outer);
            instrumentationNode.setExpression((AstNode)inc);
            instrumentationNode.setHasResult();
            return instrumentationNode;
        }
    }
}

