/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.File;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

final class UriUtil {
    private static final Pattern supportedUriSchemeRe = Pattern.compile("(https?|file)");

    private UriUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    static URI toUri(String s) {
        URI uri = URI.create(s);
        if (uri.getScheme() != null) {
            Matcher matcher = supportedUriSchemeRe.matcher(uri.getScheme());
            Preconditions.checkArgument((boolean)matcher.find(), (Object)"Supported URI schemes are: http, https and file");
            return uri;
        }
        return new File(s).toURI().normalize();
    }

    static boolean isFileUri(URI uri) {
        return "file".equals(uri.getScheme());
    }

    static Optional<String> getLastSegment(URI uri) {
        return UriUtil.getSegment(uri, -1);
    }

    private static Optional<String> getSegment(URI uri, int index) {
        int actualIndex;
        String path = uri.getPath();
        if (StringUtils.isBlank((CharSequence)path)) {
            return Optional.absent();
        }
        if (!path.contains("/")) {
            return Optional.of((Object)path);
        }
        Iterable parts = Splitter.on((char)'/').omitEmptyStrings().trimResults().split((CharSequence)path);
        int size = Iterables.size((Iterable)parts);
        int n = actualIndex = index < 0 ? size + index : index;
        if (actualIndex < 0 || actualIndex > size - 1) {
            return Optional.absent();
        }
        return Optional.of((Object)Iterables.get((Iterable)parts, (int)actualIndex));
    }

    static String getLastSegmentOrHost(URI uri) {
        Optional<String> segment = UriUtil.getLastSegment(uri);
        if (segment.isPresent()) {
            return (String)segment.get();
        }
        return uri.getHost();
    }

    static String getParent(URI uri) {
        String path = uri.getPath();
        if (StringUtils.isBlank((CharSequence)path)) {
            return "/";
        }
        String parent = path.substring(0, path.lastIndexOf(47)).trim();
        return StringUtils.isBlank((CharSequence)parent) ? "/" : parent;
    }

    static String getPath(URI uri) {
        return UriUtil.isFileUri(uri) ? uri.getPath() : uri.toString();
    }
}

