/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.SilentCssErrorHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import com.github.timurstrekalov.saga.core.Config;
import com.github.timurstrekalov.saga.core.QuietHtmlParserListener;
import com.github.timurstrekalov.saga.core.QuietIncorrectnessListener;
import com.github.timurstrekalov.saga.core.QuietJavaScriptErrorListener;
import com.github.timurstrekalov.saga.core.WebResponseProxy;
import java.io.IOException;
import org.w3c.css.sac.ErrorHandler;

class WebClientFactory {
    private static final IncorrectnessListener quietIncorrectnessListener = new QuietIncorrectnessListener();
    private static final JavaScriptErrorListener loggingJsErrorListener = new QuietJavaScriptErrorListener();
    private static final HTMLParserListener quietHtmlParserListener = new QuietHtmlParserListener();
    private static final SilentCssErrorHandler quietCssErrorHandler = new SilentCssErrorHandler();

    private WebClientFactory() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static WebClient newInstance(Config config) {
        WebClient client = new WebClient(config.getBrowserVersion()){

            public WebResponse loadWebResponse(WebRequest webRequest) throws IOException {
                return new WebResponseProxy(super.loadWebResponse(webRequest));
            }
        };
        client.setIncorrectnessListener(quietIncorrectnessListener);
        client.setJavaScriptErrorListener(loggingJsErrorListener);
        client.setHTMLParserListener(quietHtmlParserListener);
        client.setCssErrorHandler((ErrorHandler)quietCssErrorHandler);
        client.getOptions().setJavaScriptEnabled(true);
        client.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        client.getOptions().setThrowExceptionOnScriptError(false);
        client.getOptions().setThrowExceptionOnFailingStatusCode(false);
        client.getOptions().setPrintContentOnFailingStatusCode(false);
        client.setWebConnection((WebConnection)new HttpWebConnection(client){

            protected WebResponse newWebResponseInstance(WebResponseData responseData, long loadTime, WebRequest request) {
                return new WebResponseProxy(super.newWebResponseInstance(responseData, loadTime, request));
            }
        });
        return client;
    }
}

