/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.reporter;

import com.github.timurstrekalov.saga.core.ReportFormat;
import com.github.timurstrekalov.saga.core.RunStats;
import com.github.timurstrekalov.saga.core.reporter.AbstractStringTemplateBasedReporter;
import com.github.timurstrekalov.saga.core.reporter.Reporter;
import com.github.timurstrekalov.saga.core.reporter.ReporterUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractReporter
implements Reporter {
    protected static final Properties config;
    protected final ReportFormat format;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractReporter(ReportFormat format) {
        this.format = format;
    }

    @Override
    public final void writeReport(URI baseUri, File outputDir, RunStats runStats) throws IOException {
        File fileOutputDir = ReporterUtil.getFileOutputDir(baseUri, outputDir, runStats);
        FileUtils.mkdir((String)fileOutputDir.getAbsolutePath());
        File outputFile = new File(fileOutputDir, this.getReportName(runStats));
        this.logger.info("Writing {} coverage report: {}", (Object)this.format.name(), (Object)outputFile.getAbsoluteFile());
        this.writeReportInternal(outputFile, runStats);
    }

    protected abstract void writeReportInternal(File var1, RunStats var2) throws IOException;

    private String getReportName(RunStats runStats) {
        return String.format("%s-%s.%s", runStats.getTestName(), this.format.getSuffix(), this.format.getExtension());
    }

    static {
        try {
            config = new Properties();
            config.load(AbstractStringTemplateBasedReporter.class.getResourceAsStream("/app.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading configuration", e);
        }
    }
}

