/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.reporter;

import com.github.timurstrekalov.saga.core.FileStats;
import com.github.timurstrekalov.saga.core.ReportFormat;
import com.github.timurstrekalov.saga.core.RunStats;
import com.github.timurstrekalov.saga.core.reporter.AbstractReporter;
import com.itextpdf.text.Anchor;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class PdfReporter
extends AbstractReporter {
    private static final BaseColor COLOR_HEADER = new BaseColor(117, 134, 145);
    private static final BaseColor COLOR_ROW_ODD = BaseColor.WHITE;
    private static final BaseColor COLOR_ROW_EVEN = new BaseColor(231, 232, 233);
    private static final String FONT_VERDANA = "Verdana";
    private static final Font FONT_H1;
    private static final Font FONT_TH;
    private static final Font FONT_TOTAL;
    private static final Font FONT_TD;
    private static final Font FONT_TD_BOLD;
    private static final Font FONT_TD_EMPTY_FILE;
    private static final Font FONT_TD_BOLD_EMPTY_FILE;
    private static final Font FONT_FOOTER;
    private static final int PADDING_BOTTOM = 4;
    private static final int PADDING_TOP = 1;
    private static final int PADDING_LEFT = 6;
    private static final int PADDING_RIGHT = 6;
    private Document document;
    private PdfWriter writer;

    public PdfReporter() {
        super(ReportFormat.PDF);
    }

    @Override
    public void writeReportInternal(File outputFile, RunStats runStats) throws IOException {
        try {
            this.document = new Document(PageSize.A4.rotate());
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)new FileOutputStream(outputFile));
            this.document.open();
            this.addMetaData(runStats);
            this.addContent(runStats);
            this.document.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void addMetaData(RunStats runStats) {
        this.document.addTitle(runStats.title);
    }

    private void addContent(RunStats runStats) throws DocumentException {
        Paragraph title = new Paragraph(runStats.title, FONT_H1);
        title.setIndentationLeft(6.0f);
        this.document.add((Element)title);
        this.document.add((Element)this.createTable(runStats));
        this.document.add(this.createFooter());
    }

    private PdfPTable createTable(RunStats runStats) throws DocumentException {
        PdfPTable table = new PdfPTable(4);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(10.0f);
        table.setWidthPercentage(100.0f);
        table.setHeaderRows(1);
        table.setWidths(new int[]{70, 10, 10, 10});
        this.addHeader(table);
        this.addTotalRow(runStats, table);
        this.addFileStatsRows(runStats, table);
        return table;
    }

    private void addHeader(PdfPTable table) {
        table.addCell(PdfReporter.createCell("File", FONT_TH, 0, COLOR_HEADER));
        table.addCell(PdfReporter.createCell("Statements", FONT_TH, 1, COLOR_HEADER));
        table.addCell(PdfReporter.createCell("Executed", FONT_TH, 2, COLOR_HEADER));
        table.addCell(PdfReporter.createCell("Coverage", FONT_TH, 3, COLOR_HEADER));
    }

    private Element createFooter() {
        Paragraph footer = new Paragraph();
        footer.add((Element)new Phrase("Generated using ", FONT_FOOTER));
        Anchor a = new Anchor(config.getProperty("app.name"), FONT_FOOTER);
        a.setReference("http://timurstrekalov.github.com/saga/");
        footer.add((Element)a);
        footer.add((Element)new Phrase(" version " + config.getProperty("app.version"), FONT_FOOTER));
        footer.setAlignment(2);
        return footer;
    }

    private void addTotalRow(RunStats runStats, PdfPTable table) {
        table.addCell(PdfReporter.createCell("Total", FONT_TOTAL, 0));
        table.addCell(PdfReporter.createCell(String.valueOf(runStats.getTotalStatements()), FONT_TOTAL, 1));
        table.addCell(PdfReporter.createCell(String.valueOf(runStats.getTotalExecuted()), FONT_TOTAL, 2));
        table.addCell(PdfReporter.createCell(runStats.getTotalCoverage() + "%", FONT_TOTAL, 3));
    }

    private void addFileStatsRows(RunStats runStats, PdfPTable table) {
        List<FileStats> allFileStats = runStats.getFileStats();
        for (int i = 0; i < allFileStats.size(); ++i) {
            FileStats fileStats = allFileStats.get(i);
            boolean hasStatements = fileStats.getHasStatements();
            Phrase fileName = new Phrase();
            if (fileStats.getParentName() != null) {
                fileName.add((Element)new Chunk(fileStats.getParentName() + "/", hasStatements ? FONT_TD : FONT_TD_EMPTY_FILE));
                fileName.add((Element)new Chunk(fileStats.getFileName(), hasStatements ? FONT_TD_BOLD : FONT_TD_BOLD_EMPTY_FILE));
            } else {
                fileName.add((Element)new Chunk(fileStats.getFileName(), hasStatements ? FONT_TD : FONT_TD_EMPTY_FILE));
            }
            BaseColor bgColor = i % 2 == 1 ? COLOR_ROW_ODD : COLOR_ROW_EVEN;
            Font font = FONT_TD;
            table.addCell(PdfReporter.createCell(fileName, 0, bgColor));
            table.addCell(PdfReporter.createCell(String.valueOf(fileStats.getStatements()), font, 1, bgColor));
            table.addCell(PdfReporter.createCell(String.valueOf(fileStats.getExecuted()), font, 2, bgColor));
            table.addCell(PdfReporter.createCell(fileStats.getCoverage() + "%", FONT_TD, 3, bgColor));
        }
    }

    private static PdfPCell createCell(Phrase text, int index) {
        return PdfReporter.createCell(text, index, BaseColor.WHITE);
    }

    private static PdfPCell createCell(String text, Font font, int index, BaseColor bgColor) {
        return PdfReporter.createCell(new Phrase(text, font), index, bgColor);
    }

    private static PdfPCell createCell(String text, Font font, int index) {
        return PdfReporter.createCell(new Phrase(text, font), index, BaseColor.WHITE);
    }

    private static PdfPCell createCell(Phrase text, int index, BaseColor bgColor) {
        PdfPCell cell = new PdfPCell(text);
        cell.setHorizontalAlignment(index == 0 ? 0 : 2);
        cell.setVerticalAlignment(5);
        cell.setBackgroundColor(bgColor);
        cell.setBorderWidth(0.0f);
        cell.setPaddingBottom(4.0f);
        cell.setPaddingTop(1.0f);
        cell.setPaddingLeft(6.0f);
        cell.setPaddingRight(6.0f);
        return cell;
    }

    static {
        FontFactory.register((String)"/fonts/Verdana.ttf");
        FONT_H1 = FontFactory.getFont((String)FONT_VERDANA, (float)16.0f, (int)1);
        FONT_TH = FontFactory.getFont((String)FONT_VERDANA, (float)11.0f, (int)1, (BaseColor)BaseColor.WHITE);
        FONT_TOTAL = FontFactory.getFont((String)FONT_VERDANA, (float)13.0f, (int)1);
        FONT_TD = FontFactory.getFont((String)FONT_VERDANA, (float)13.0f, (int)0);
        FONT_TD_BOLD = FontFactory.getFont((String)FONT_VERDANA, (float)13.0f, (int)1);
        FONT_TD_EMPTY_FILE = FontFactory.getFont((String)FONT_VERDANA, (float)13.0f, (int)0, (BaseColor)BaseColor.GRAY);
        FONT_TD_BOLD_EMPTY_FILE = FontFactory.getFont((String)FONT_VERDANA, (float)13.0f, (int)1, (BaseColor)BaseColor.GRAY);
        FONT_FOOTER = FontFactory.getFont((String)FONT_VERDANA, (float)11.0f, (int)2, (BaseColor)BaseColor.GRAY);
    }
}

