/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;

public class HandlebarsRandomValuesHelper
extends HandlebarsHelper<Void> {
    public Object apply(Void context, Options options) throws IOException {
        String rawValue;
        String type;
        int length = (Integer)options.hash("length", (Object)36);
        boolean uppercase = (Boolean)options.hash("uppercase", (Object)false);
        switch (type = (String)options.hash("type", (Object)"ALPHANUMERIC")) {
            case "ALPHANUMERIC": {
                rawValue = RandomStringUtils.randomAlphanumeric((int)length);
                break;
            }
            case "ALPHABETIC": {
                rawValue = RandomStringUtils.randomAlphabetic((int)length);
                break;
            }
            case "NUMERIC": {
                rawValue = RandomStringUtils.randomNumeric((int)length);
                break;
            }
            case "ALPHANUMERIC_AND_SYMBOLS": {
                rawValue = RandomStringUtils.random((int)length);
                break;
            }
            case "UUID": {
                rawValue = UUID.randomUUID().toString();
                break;
            }
            default: {
                rawValue = RandomStringUtils.randomAscii((int)length);
            }
        }
        return uppercase ? rawValue.toUpperCase() : rawValue.toLowerCase();
    }
}

