/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.store;

import com.github.tomakehurst.wiremock.store.StubMappingStore;
import com.github.tomakehurst.wiremock.stubbing.SortedConcurrentMappingSet;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;

public class InMemoryStubMappingStore
implements StubMappingStore {
    private final SortedConcurrentMappingSet mappings = new SortedConcurrentMappingSet();

    @Override
    public Optional<StubMapping> get(UUID id) {
        return this.mappings.stream().filter(stubMapping -> stubMapping.getId().equals(id)).findFirst();
    }

    @Override
    public void remove(StubMapping stubMapping) {
        this.mappings.remove(stubMapping);
    }

    @Override
    public void clear() {
        this.mappings.clear();
    }

    @Override
    public Stream<StubMapping> getAll() {
        return this.mappings.stream();
    }

    @Override
    public void add(StubMapping stubMapping) {
        this.mappings.add(stubMapping);
    }

    @Override
    public void replace(StubMapping existing, StubMapping updated) {
        this.mappings.replace(existing, updated);
    }
}

