/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.url;

import com.github.tomakehurst.wiremock.common.url.PathParams;
import com.github.tomakehurst.wiremock.common.url.Renderer;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class RendererBuilder {
    private final List<Function<PathParams, String>> tasks = new ArrayList<Function<PathParams, String>>();
    private int wildcardCount = 0;

    RendererBuilder() {
    }

    void addStatic(final String text) {
        class Static
        implements Function<PathParams, String> {
            Static() {
            }

            public String apply(PathParams input) {
                return text;
            }
        }
        this.tasks.add(new Static());
    }

    void addVariable(final String variable) {
        class Variable
        implements Function<PathParams, String> {
            Variable() {
            }

            public String apply(PathParams input) {
                String value = (String)input.get(variable);
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Path parameter %s was not bound", variable));
                }
                return value;
            }
        }
        this.tasks.add(new Variable());
    }

    void addWildcard() {
        final String wildcardIndex = "" + this.wildcardCount++;
        class Wildcard
        implements Function<PathParams, String> {
            Wildcard() {
            }

            public String apply(PathParams input) {
                String value = (String)input.get(wildcardIndex);
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Wildcard was not bound", new Object[0]));
                }
                return value;
            }
        }
        this.tasks.add(new Wildcard());
    }

    Renderer build() {
        return new Renderer(Collections.unmodifiableList(this.tasks));
    }
}

