/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.filemaker.FilenameMaker;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.recording.CaptureHeadersSpec;
import com.github.tomakehurst.wiremock.recording.LoggedResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import com.github.tomakehurst.wiremock.recording.RequestPatternTransformer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.base.Function;
import java.net.URI;
import java.util.Map;

public class SnapshotStubMappingGenerator
implements Function<ServeEvent, StubMapping> {
    private final RequestPatternTransformer requestTransformer;
    private final LoggedResponseDefinitionTransformer responseTransformer;

    public SnapshotStubMappingGenerator(RequestPatternTransformer requestTransformer, LoggedResponseDefinitionTransformer responseTransformer) {
        this.requestTransformer = requestTransformer;
        this.responseTransformer = responseTransformer;
    }

    public SnapshotStubMappingGenerator(Map<String, CaptureHeadersSpec> captureHeaders, RequestBodyPatternFactory requestBodyPatternFactory) {
        this(new RequestPatternTransformer(captureHeaders, requestBodyPatternFactory), new LoggedResponseDefinitionTransformer());
    }

    public StubMapping apply(ServeEvent event) {
        RequestPattern requestPattern = this.requestTransformer.apply(event.getRequest()).build();
        ResponseDefinition responseDefinition = this.responseTransformer.apply(event.getResponse());
        StubMapping stubMapping = new StubMapping(requestPattern, responseDefinition);
        URI uri = URI.create(event.getRequest().getUrl());
        FilenameMaker filenameMaker = new FilenameMaker();
        stubMapping.setName(filenameMaker.sanitizeUrl(uri.getPath()));
        return stubMapping;
    }
}

