/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta;

import com.github.veithen.alta.AbstractGenerateMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerateFilesMojo
extends AbstractGenerateMojo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void process(Map<String, String> result) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        File outputDirectory = this.getOutputDirectory();
        for (Map.Entry<String, String> entry : result.entrySet()) {
            String resource = entry.getKey();
            File outputFile = new File(outputDirectory, resource);
            File parentDir = outputFile.getParentFile();
            if (!parentDir.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("Creating directory " + parentDir));
                }
                if (!parentDir.mkdirs()) {
                    throw new MojoExecutionException("Unable to create directory " + parentDir);
                }
            }
            try {
                FileOutputStream fos = new FileOutputStream(outputFile);
                try {
                    OutputStreamWriter out = new OutputStreamWriter(fos);
                    out.write(entry.getValue());
                    ((Writer)out).flush();
                }
                finally {
                    fos.close();
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Failed to write file " + outputFile, (Exception)ex);
            }
        }
        this.postProcess(outputDirectory);
    }

    protected abstract File getOutputDirectory();

    protected abstract void postProcess(File var1);
}

