/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta;

import com.github.veithen.alta.ArtifactItem;
import com.github.veithen.alta.Bundle;
import com.github.veithen.alta.Context;
import com.github.veithen.alta.DependencySet;
import com.github.veithen.alta.template.EvaluationException;
import com.github.veithen.alta.template.InvalidTemplateException;
import com.github.veithen.alta.template.Property;
import com.github.veithen.alta.template.PropertyGroup;
import com.github.veithen.alta.template.Template;
import com.github.veithen.alta.template.TemplateCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerateMojo
extends AbstractMojo {
    private static final TemplateCompiler<Context> templateCompiler = new TemplateCompiler();
    @Parameter(required=true)
    private String name;
    @Parameter(required=true)
    private String value;
    @Parameter
    private String separator;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter
    private DependencySet dependencySet;
    @Parameter
    private ArtifactItem[] artifacts;
    @Parameter
    private Repository[] repositories;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactFactory factory;
    @Component
    private ArtifactCollector artifactCollector;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactResolver resolver;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        Template<Context> valueTemplate;
        Template<Context> nameTemplate;
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping plugin execution");
            return;
        }
        try {
            nameTemplate = templateCompiler.compile(this.name);
        }
        catch (InvalidTemplateException ex) {
            throw new MojoExecutionException("Invalid destination name template", (Exception)ex);
        }
        try {
            valueTemplate = templateCompiler.compile(this.value);
        }
        catch (InvalidTemplateException ex) {
            throw new MojoExecutionException("Invalid value template", (Exception)ex);
        }
        ArrayList<Artifact> resolvedArtifacts = new ArrayList<Artifact>();
        if (this.dependencySet != null) {
            Set artifacts;
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Resolving project dependencies in scope " + this.dependencySet.getScope()));
            }
            ScopeArtifactFilter filter = new ScopeArtifactFilter(this.dependencySet.getScope());
            try {
                artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.factory, (List)this.project.getDependencies(), null, (ArtifactFilter)filter, (MavenProject)this.project);
            }
            catch (InvalidDependencyVersionException ex) {
                throw new MojoExecutionException("Failed to collect project dpendencies", (Exception)((Object)ex));
            }
            try {
                resolvedArtifacts.addAll(this.resolver.resolveTransitively(artifacts, this.project.getArtifact(), this.project.getRemoteArtifactRepositories(), this.localRepository, this.artifactMetadataSource).getArtifacts());
            }
            catch (ArtifactResolutionException ex) {
                throw new MojoExecutionException("Unable to resolve artifact", (Exception)((Object)ex));
            }
            catch (ArtifactNotFoundException ex) {
                throw new MojoExecutionException("Artifact not found", (Exception)((Object)ex));
            }
            if (this.dependencySet.isUseProjectArtifact()) {
                resolvedArtifacts.add(this.project.getArtifact());
            }
        }
        if (this.artifacts != null && this.artifacts.length != 0) {
            ArrayList effectiveRepositories;
            ArrayList pomRepositories = this.project.getRemoteArtifactRepositories();
            if (this.repositories != null && this.repositories.length > 0) {
                effectiveRepositories = new ArrayList(pomRepositories.size() + this.repositories.length);
                effectiveRepositories.addAll(pomRepositories);
                for (ArtifactItem artifactItem : this.repositories) {
                    try {
                        effectiveRepositories.add(this.repositorySystem.buildArtifactRepository((Repository)artifactItem));
                    }
                    catch (InvalidRepositoryException ex) {
                        throw new MojoExecutionException("Invalid repository", (Exception)((Object)ex));
                    }
                }
            } else {
                effectiveRepositories = pomRepositories;
            }
            for (ArtifactItem artifactItem : this.artifacts) {
                VersionRange versionRange;
                String version = artifactItem.getVersion();
                if (StringUtils.isEmpty((String)version)) {
                    version = this.getMissingArtifactVersion(artifactItem);
                }
                try {
                    versionRange = VersionRange.createFromVersionSpec((String)version);
                }
                catch (InvalidVersionSpecificationException ex) {
                    throw new MojoExecutionException("Invalid version specified for artifact " + artifactItem.getGroupId() + ":" + artifactItem.getArtifactId(), (Exception)((Object)ex));
                }
                Artifact artifact = this.factory.createDependencyArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), versionRange, artifactItem.getType(), artifactItem.getClassifier(), "compile");
                try {
                    ArtifactResolutionResult artifactResolutionResult = this.artifactCollector.collect(Collections.singleton(artifact), this.project.getArtifact(), this.localRepository, effectiveRepositories, this.artifactMetadataSource, null, Collections.EMPTY_LIST);
                    artifact = ((ResolutionNode)artifactResolutionResult.getArtifactResolutionNodes().iterator().next()).getArtifact();
                    this.resolver.resolve(artifact, effectiveRepositories, this.localRepository);
                }
                catch (ArtifactResolutionException ex) {
                    throw new MojoExecutionException("Unable to resolve artifact", (Exception)((Object)ex));
                }
                catch (ArtifactNotFoundException ex) {
                    throw new MojoExecutionException("Artifact not found", (Exception)((Object)ex));
                }
                resolvedArtifacts.add(artifact);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Artifact artifact : resolvedArtifacts) {
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Processing artifact " + artifact.getId()));
            }
            Context context = new Context(artifact);
            try {
                String name = nameTemplate.evaluate(context);
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("name = " + name));
                }
                if (name == null) continue;
                String string = valueTemplate.evaluate(context);
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("value = " + string));
                }
                if (string == null) continue;
                String currentValue = (String)result.get(name);
                if (currentValue == null) {
                    currentValue = string;
                } else {
                    if (this.separator == null) {
                        throw new MojoExecutionException("No separator configured");
                    }
                    currentValue = currentValue + this.separator + string;
                }
                result.put(name, currentValue);
            }
            catch (EvaluationException ex) {
                throw new MojoExecutionException("Failed to process artifact " + artifact.getId() + ": " + ex.getMessage(), (Exception)ex);
            }
        }
        this.process(result);
    }

    private String getMissingArtifactVersion(ArtifactItem artifact) throws MojoExecutionException {
        List dependencies = this.project.getDependencies();
        List managedDependencies = this.project.getDependencyManagement() == null ? null : this.project.getDependencyManagement().getDependencies();
        String version = this.findDependencyVersion(artifact, dependencies, false);
        if (version == null && managedDependencies != null) {
            version = this.findDependencyVersion(artifact, managedDependencies, false);
        }
        if (version == null) {
            version = this.findDependencyVersion(artifact, dependencies, true);
        }
        if (version == null && managedDependencies != null) {
            version = this.findDependencyVersion(artifact, managedDependencies, true);
        }
        if (version == null) {
            throw new MojoExecutionException("Unable to find artifact version of " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " in either dependency list or in project's dependency management.");
        }
        return version;
    }

    private String findDependencyVersion(ArtifactItem artifact, List<Dependency> dependencies, boolean looseMatch) {
        for (Dependency dependency : dependencies) {
            if (!StringUtils.equals((String)dependency.getArtifactId(), (String)artifact.getArtifactId()) || !StringUtils.equals((String)dependency.getGroupId(), (String)artifact.getGroupId()) || !looseMatch && !StringUtils.equals((String)dependency.getClassifier(), (String)artifact.getClassifier()) || !looseMatch && !StringUtils.equals((String)dependency.getType(), (String)artifact.getType())) continue;
            return dependency.getVersion();
        }
        return null;
    }

    static File getArtifactFile(Artifact artifact) throws EvaluationException {
        File file = artifact.getFile();
        if (file.isFile()) {
            return file;
        }
        throw new EvaluationException("Artifact has not been packaged yet; it is part of the reactor, but the package phase has not been executed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Bundle extractBundleMetadata(Artifact artifact) throws EvaluationException {
        File file = AbstractGenerateMojo.getArtifactFile(artifact);
        try {
            String symbolicName;
            Manifest manifest = null;
            FileInputStream in = new FileInputStream(file);
            try {
                ZipEntry entry;
                ZipInputStream zip = new ZipInputStream(in);
                while ((entry = zip.getNextEntry()) != null) {
                    if (!entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                    manifest = new Manifest(zip);
                    break;
                }
            }
            finally {
                ((InputStream)in).close();
            }
            if (manifest != null && (symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
                int idx = symbolicName.indexOf(59);
                if (idx != -1) {
                    symbolicName = symbolicName.substring(0, idx);
                }
                return new Bundle(symbolicName.trim());
            }
            return null;
        }
        catch (IOException ex) {
            throw new EvaluationException("Failed to read " + file, ex);
        }
    }

    protected abstract void process(Map<String, String> var1) throws MojoExecutionException, MojoFailureException;

    static {
        PropertyGroup<Context, Artifact> artifactGroup = new PropertyGroup<Context, Artifact>(Artifact.class){

            @Override
            public Artifact prepare(Context context) throws EvaluationException {
                return context.getArtifact();
            }
        };
        artifactGroup.addProperty("artifactId", new Property<Artifact>(){

            @Override
            public String evaluate(Artifact artifact) {
                return artifact.getArtifactId();
            }
        });
        artifactGroup.addProperty("groupId", new Property<Artifact>(){

            @Override
            public String evaluate(Artifact artifact) {
                return artifact.getGroupId();
            }
        });
        artifactGroup.addProperty("version", new Property<Artifact>(){

            @Override
            public String evaluate(Artifact artifact) {
                return artifact.getVersion();
            }
        });
        artifactGroup.addProperty("file", new Property<Artifact>(){

            @Override
            public String evaluate(Artifact artifact) throws EvaluationException {
                return AbstractGenerateMojo.getArtifactFile(artifact).getPath();
            }
        });
        artifactGroup.addProperty("url", new Property<Artifact>(){

            @Override
            public String evaluate(Artifact artifact) throws EvaluationException {
                try {
                    return AbstractGenerateMojo.getArtifactFile(artifact).toURI().toURL().toString();
                }
                catch (MalformedURLException ex) {
                    throw new EvaluationException("Unexpected exception", ex);
                }
            }
        });
        templateCompiler.setDefaultPropertyGroup(artifactGroup);
        PropertyGroup<Context, Bundle> bundleGroup = new PropertyGroup<Context, Bundle>(Bundle.class){

            @Override
            public Bundle prepare(Context context) throws EvaluationException {
                return AbstractGenerateMojo.extractBundleMetadata(context.getArtifact());
            }
        };
        bundleGroup.addProperty("symbolicName", new Property<Bundle>(){

            @Override
            public String evaluate(Bundle bundle) {
                return bundle.getSymbolicName();
            }
        });
        templateCompiler.addPropertyGroup("bundle", bundleGroup);
    }
}

