/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.alta.template;

import com.github.veithen.alta.template.InvalidTemplateException;
import com.github.veithen.alta.template.Property;
import com.github.veithen.alta.template.PropertyExpression;
import com.github.veithen.alta.template.PropertyGroup;
import com.github.veithen.alta.template.Template;
import com.github.veithen.alta.template.Text;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplateCompiler<C> {
    private Map<String, PropertyGroup<C, ?>> propertyGroups = new HashMap();
    private PropertyGroup<C, ?> defaultPropertyGroup;

    public void addPropertyGroup(String name, PropertyGroup<C, ?> group) {
        this.propertyGroups.put(name, group);
    }

    public void setDefaultPropertyGroup(PropertyGroup<C, ?> group) {
        this.defaultPropertyGroup = group;
    }

    public Template<C> compile(String s) throws InvalidTemplateException {
        ArrayList expressions = new ArrayList();
        int pos = 0;
        while (pos < s.length()) {
            String propertyName;
            PropertyGroup<C, ?> group;
            String expressionString;
            int dotIndex;
            int idx1 = s.indexOf(37, pos);
            if (idx1 == -1) {
                expressions.add(new Text(s.substring(pos, s.length())));
                break;
            }
            int idx2 = s.indexOf(37, idx1 + 1);
            if (idx2 == -1) {
                throw new InvalidTemplateException("Unmatched '%' at position " + idx1);
            }
            if (idx1 != pos) {
                expressions.add(new Text(s.substring(pos, idx1)));
            }
            if ((dotIndex = (expressionString = s.substring(idx1 + 1, idx2)).indexOf(46)) == -1) {
                group = this.defaultPropertyGroup;
                propertyName = expressionString;
            } else {
                String groupName = expressionString.substring(0, dotIndex);
                group = this.propertyGroups.get(groupName);
                if (group == null) {
                    throw new InvalidTemplateException("Unknown property group '" + groupName + "' at position " + (idx1 + 1));
                }
                propertyName = expressionString.substring(dotIndex + 1);
            }
            PropertyExpression<C, ?> expression = this.createPropertyExpression(group, propertyName);
            if (expression == null) {
                throw new InvalidTemplateException("Unknown property '" + propertyName + "' at position " + (idx1 + 1));
            }
            expressions.add(expression);
            pos = idx2 + 1;
        }
        return new Template(expressions);
    }

    private <CG> PropertyExpression<C, CG> createPropertyExpression(PropertyGroup<C, CG> group, String propertyName) {
        Property<CG> property = group.getProperty(propertyName);
        return property == null ? null : new PropertyExpression<C, CG>(group, property);
    }
}

