// Copyright 2021 Tencent Inc. All rights reserved.
//
// 获取账单文件下载地址的对外API
//
// 为方便商户快速查询和核对账务信息，支持通过本接口获取离线账单的下载地址。
//
// API version: 2.1.4

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.billdownload;

import static com.wechat.pay.java.core.http.UrlEncoder.urlEncode;
import static com.wechat.pay.java.core.util.GsonUtil.toJson;
import static java.util.Objects.requireNonNull;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.exception.HttpException;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.Constant;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.service.billdownload.model.GetAllSubMchFundFlowBillRequest;
import com.wechat.pay.java.service.billdownload.model.GetFundFlowBillRequest;
import com.wechat.pay.java.service.billdownload.model.GetSingleSubMchFundFlowBillRequest;
import com.wechat.pay.java.service.billdownload.model.GetTradeBillRequest;
import com.wechat.pay.java.service.billdownload.model.QueryBillEntity;
import com.wechat.pay.java.service.billdownload.model.QueryEncryptBillEntity;

/** BillDownloadService服务 */
public class BillDownloadService {

  private final HttpClient httpClient;
  private final HostName hostName;
  private final PrivacyDecryptor decryptor;

  private BillDownloadService(
      HttpClient httpClient, HostName hostName, PrivacyDecryptor decryptor) {
    this.httpClient = requireNonNull(httpClient);
    this.hostName = hostName;

    this.decryptor = requireNonNull(decryptor);
  }
  /** BillDownloadService构造器 */
  public static class Builder {

    private HttpClient httpClient;
    private HostName hostName;

    private PrivacyDecryptor decryptor;

    public Builder config(Config config) {
      this.httpClient = new DefaultHttpClientBuilder().config(config).build();

      this.decryptor = config.createDecryptor();
      return this;
    }

    public Builder hostName(HostName hostName) {
      this.hostName = hostName;
      return this;
    }

    public Builder httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      return this;
    }

    public Builder decryptor(PrivacyDecryptor decryptor) {
      this.decryptor = decryptor;
      return this;
    }

    public BillDownloadService build() {
      return new BillDownloadService(httpClient, hostName, decryptor);
    }
  }

  /**
   * 申请资金账单API
   *
   * @param request 请求参数
   * @return QueryBillEntity
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public QueryBillEntity getFundFlowBill(GetFundFlowBillRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/bill/fundflowbill";

    GetFundFlowBillRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getBillDate() != null) {
      queryParameter.add("bill_date", urlEncode(realRequest.getBillDate()));
    }
    if (realRequest.getAccountType() != null) {
      queryParameter.add("account_type", urlEncode(realRequest.getAccountType().toString()));
    }
    if (realRequest.getTarType() != null) {
      queryParameter.add("tar_type", urlEncode(realRequest.getTarType().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<QueryBillEntity> httpResponse =
        httpClient.execute(httpRequest, QueryBillEntity.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 申请单个子商户资金账单API
   *
   * @param request 请求参数
   * @return QueryEncryptBillEntity
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public QueryEncryptBillEntity getSingleSubMchFundFlowBill(
      GetSingleSubMchFundFlowBillRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/bill/sub-merchant-fundflowbill";

    GetSingleSubMchFundFlowBillRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getSubMchid() != null) {
      queryParameter.add("sub_mchid", urlEncode(realRequest.getSubMchid()));
    }
    if (realRequest.getBillDate() != null) {
      queryParameter.add("bill_date", urlEncode(realRequest.getBillDate()));
    }
    if (realRequest.getAccountType() != null) {
      queryParameter.add("account_type", urlEncode(realRequest.getAccountType().toString()));
    }
    if (realRequest.getAlgorithm() != null) {
      queryParameter.add("algorithm", urlEncode(realRequest.getAlgorithm().toString()));
    }
    if (realRequest.getTarType() != null) {
      queryParameter.add("tar_type", urlEncode(realRequest.getTarType().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<QueryEncryptBillEntity> httpResponse =
        httpClient.execute(httpRequest, QueryEncryptBillEntity.class);
    return httpResponse.getServiceResponse().cloneWithCipher(decryptor::decrypt);
  }
  /**
   * 申请二级商户资金账单API
   *
   * @param request 请求参数
   * @return QueryEncryptBillEntity
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public QueryEncryptBillEntity getAllSubMchFundFlowBill(GetAllSubMchFundFlowBillRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/ecommerce/bill/fundflowbill";

    GetAllSubMchFundFlowBillRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getBillDate() != null) {
      queryParameter.add("bill_date", urlEncode(realRequest.getBillDate()));
    }
    if (realRequest.getAccountType() != null) {
      queryParameter.add("account_type", urlEncode(realRequest.getAccountType().toString()));
    }
    if (realRequest.getTarType() != null) {
      queryParameter.add("tar_type", urlEncode(realRequest.getTarType().toString()));
    }
    if (realRequest.getAlgorithm() != null) {
      queryParameter.add("algorithm", urlEncode(realRequest.getAlgorithm().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<QueryEncryptBillEntity> httpResponse =
        httpClient.execute(httpRequest, QueryEncryptBillEntity.class);
    return httpResponse.getServiceResponse().cloneWithCipher(decryptor::decrypt);
  }
  /**
   * 申请交易账单API
   *
   * @param request 请求参数
   * @return QueryBillEntity
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public QueryBillEntity getTradeBill(GetTradeBillRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/bill/tradebill";

    GetTradeBillRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getBillDate() != null) {
      queryParameter.add("bill_date", urlEncode(realRequest.getBillDate()));
    }
    if (realRequest.getSubMchid() != null) {
      queryParameter.add("sub_mchid", urlEncode(realRequest.getSubMchid()));
    }
    if (realRequest.getBillType() != null) {
      queryParameter.add("bill_type", urlEncode(realRequest.getBillType().toString()));
    }
    if (realRequest.getTarType() != null) {
      queryParameter.add("tar_type", urlEncode(realRequest.getTarType().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<QueryBillEntity> httpResponse =
        httpClient.execute(httpRequest, QueryBillEntity.class);
    return httpResponse.getServiceResponse();
  }

  private RequestBody createRequestBody(Object request) {
    return new JsonRequestBody.Builder().body(toJson(request)).build();
  }
}
