// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付营销系统开放API
//
// 新增立减金api
//
// API version: 3.4.0

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.cashcoupons.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/** SendCouponRequest */
public class SendCouponRequest {
  /** 批次id 说明：微信为每个批次分配的唯一id */
  @SerializedName("stock_id")
  private String stockId;
  /** 用户openid 说明：Openid信息，用户在appid下的唯一标识 */
  @SerializedName("openid")
  @Expose(serialize = false)
  private String openid;
  /** 商户单据号 说明：商户此次发放凭据号（格式：商户id+日期+流水号），商户侧需保持唯一性 */
  @SerializedName("out_request_no")
  private String outRequestNo;
  /**
   * 公众账号ID
   * 说明：微信为发券方商户分配的公众账号ID，接口传入的所有appid应该为公众号的appid（在mp.weixin.qq.com申请的），不能为APP的appid（在open.weixin.qq.com申请的）。
   */
  @SerializedName("appid")
  private String appid;
  /** 创建批次的商户号 说明：批次创建方商户号 */
  @SerializedName("stock_creator_mchid")
  private String stockCreatorMchid;
  /** 指定面额发券，面额 说明：指定面额发券场景，券面额，其他场景不需要填，单位分 */
  @SerializedName("coupon_value")
  private Long couponValue;
  /** 指定面额发券，券门槛 说明：指定面额发券批次门槛，其他场景不需要，单位分 */
  @SerializedName("coupon_minimum")
  private Long couponMinimum;

  public String getStockId() {
    return stockId;
  }

  public void setStockId(String stockId) {
    this.stockId = stockId;
  }

  public String getOpenid() {
    return openid;
  }

  public void setOpenid(String openid) {
    this.openid = openid;
  }

  public String getOutRequestNo() {
    return outRequestNo;
  }

  public void setOutRequestNo(String outRequestNo) {
    this.outRequestNo = outRequestNo;
  }

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getStockCreatorMchid() {
    return stockCreatorMchid;
  }

  public void setStockCreatorMchid(String stockCreatorMchid) {
    this.stockCreatorMchid = stockCreatorMchid;
  }

  public Long getCouponValue() {
    return couponValue;
  }

  public void setCouponValue(Long couponValue) {
    this.couponValue = couponValue;
  }

  public Long getCouponMinimum() {
    return couponMinimum;
  }

  public void setCouponMinimum(Long couponMinimum) {
    this.couponMinimum = couponMinimum;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendCouponRequest {\n");
    sb.append("    stockId: ").append(toIndentedString(stockId)).append("\n");
    sb.append("    openid: ").append(toIndentedString(openid)).append("\n");
    sb.append("    outRequestNo: ").append(toIndentedString(outRequestNo)).append("\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    stockCreatorMchid: ").append(toIndentedString(stockCreatorMchid)).append("\n");
    sb.append("    couponValue: ").append(toIndentedString(couponValue)).append("\n");
    sb.append("    couponMinimum: ").append(toIndentedString(couponMinimum)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
