// Copyright 2021 Tencent Inc. All rights reserved.
//
// 支付有礼活动对外API
//
// No description provided (generated by Openapi Generator
// https://github.com/openapitools/openapi-generator)
//
// API version: 0.1.2

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.giftactivity;

import static com.wechat.pay.java.core.http.UrlEncoder.urlEncode;
import static com.wechat.pay.java.core.util.GsonUtil.toJson;
import static java.util.Objects.requireNonNull;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.exception.HttpException;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.Constant;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.service.giftactivity.model.AddActivityMerchantRequest;
import com.wechat.pay.java.service.giftactivity.model.AddActivityMerchantResponse;
import com.wechat.pay.java.service.giftactivity.model.CreateFullSendActRequest;
import com.wechat.pay.java.service.giftactivity.model.CreateFullSendActResponse;
import com.wechat.pay.java.service.giftactivity.model.DeleteActivityMerchantRequest;
import com.wechat.pay.java.service.giftactivity.model.DeleteActivityMerchantResponse;
import com.wechat.pay.java.service.giftactivity.model.GetActDetailRequest;
import com.wechat.pay.java.service.giftactivity.model.GetActDetailResponse;
import com.wechat.pay.java.service.giftactivity.model.ListActMchResponse;
import com.wechat.pay.java.service.giftactivity.model.ListActSkuResponse;
import com.wechat.pay.java.service.giftactivity.model.ListActivitiesRequest;
import com.wechat.pay.java.service.giftactivity.model.ListActivitiesResponse;
import com.wechat.pay.java.service.giftactivity.model.ListActivityMerchantRequest;
import com.wechat.pay.java.service.giftactivity.model.ListActivitySkuRequest;
import com.wechat.pay.java.service.giftactivity.model.TerminateActResponse;
import com.wechat.pay.java.service.giftactivity.model.TerminateActivityRequest;

/** GiftActivityService服务 */
public class GiftActivityService {

  private final HttpClient httpClient;
  private final HostName hostName;

  private GiftActivityService(HttpClient httpClient, HostName hostName) {
    this.httpClient = requireNonNull(httpClient);
    this.hostName = hostName;
  }
  /** GiftActivityService构造器 */
  public static class Builder {

    private HttpClient httpClient;
    private HostName hostName;

    public Builder config(Config config) {
      this.httpClient = new DefaultHttpClientBuilder().config(config).build();

      return this;
    }

    public Builder hostName(HostName hostName) {
      this.hostName = hostName;
      return this;
    }

    public Builder httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      return this;
    }

    public GiftActivityService build() {
      return new GiftActivityService(httpClient, hostName);
    }
  }

  /**
   * 新增活动发券商户号
   *
   * @param request 请求参数
   * @return AddActivityMerchantResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public AddActivityMerchantResponse addActivityMerchant(AddActivityMerchantRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/merchants/add";

    AddActivityMerchantRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<AddActivityMerchantResponse> httpResponse =
        httpClient.execute(httpRequest, AddActivityMerchantResponse.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 创建全场满额送活动
   *
   * @param request 请求参数
   * @return CreateFullSendActResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public CreateFullSendActResponse createFullSendAct(CreateFullSendActRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/unique-threshold-activity";
    CreateFullSendActRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<CreateFullSendActResponse> httpResponse =
        httpClient.execute(httpRequest, CreateFullSendActResponse.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 删除活动发券商户号
   *
   * @param request 请求参数
   * @return DeleteActivityMerchantResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public DeleteActivityMerchantResponse deleteActivityMerchant(
      DeleteActivityMerchantRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/merchants/delete";

    DeleteActivityMerchantRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<DeleteActivityMerchantResponse> httpResponse =
        httpClient.execute(httpRequest, DeleteActivityMerchantResponse.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 获取活动详情接口
   *
   * @param request 请求参数
   * @return GetActDetailResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public GetActDetailResponse getActDetail(GetActDetailRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}";

    GetActDetailRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<GetActDetailResponse> httpResponse =
        httpClient.execute(httpRequest, GetActDetailResponse.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 获取支付有礼活动列表
   *
   * @param request 请求参数
   * @return ListActivitiesResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public ListActivitiesResponse listActivities(ListActivitiesRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities";

    ListActivitiesRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    if (realRequest.getActivityName() != null) {
      queryParameter.add("activity_name", urlEncode(realRequest.getActivityName()));
    }
    if (realRequest.getActivityStatus() != null) {
      queryParameter.add("activity_status", urlEncode(realRequest.getActivityStatus().toString()));
    }
    if (realRequest.getAwardType() != null) {
      queryParameter.add("award_type", urlEncode(realRequest.getAwardType().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<ListActivitiesResponse> httpResponse =
        httpClient.execute(httpRequest, ListActivitiesResponse.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 获取活动发券商户号
   *
   * @param request 请求参数
   * @return ListActMchResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public ListActMchResponse listActivityMerchant(ListActivityMerchantRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/merchants";

    ListActivityMerchantRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<ListActMchResponse> httpResponse =
        httpClient.execute(httpRequest, ListActMchResponse.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 获取活动指定商品列表
   *
   * @param request 请求参数
   * @return ListActSkuResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public ListActSkuResponse listActivitySku(ListActivitySkuRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/goods";

    ListActivitySkuRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<ListActSkuResponse> httpResponse =
        httpClient.execute(httpRequest, ListActSkuResponse.class);
    return httpResponse.getServiceResponse();
  }
  /**
   * 终止活动
   *
   * @param request 请求参数
   * @return TerminateActResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public TerminateActResponse terminateActivity(TerminateActivityRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/paygiftactivity/activities/{activity_id}/terminate";

    TerminateActivityRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "activity_id" + "}", urlEncode(realRequest.getActivityId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<TerminateActResponse> httpResponse =
        httpClient.execute(httpRequest, TerminateActResponse.class);
    return httpResponse.getServiceResponse();
  }

  private RequestBody createRequestBody(Object request) {
    return new JsonRequestBody.Builder().body(toJson(request)).build();
  }
}
