// Copyright 2021 Tencent Inc. All rights reserved.
//
// 银行营销对外API
//
// # 前言
// 银行营销API是专为银行商户设置的一套API。目前仅包含“创建快捷交易协议号上传任务”接口，供银行上传快捷交易协议号文件。微信侧收到文件中，将快捷交易协议号转换为微信用户id，存储到指定的号码包文件中。
//
// API version: 0.1.0

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.marketingbankpackages.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** CreateTaskRequest */
public class CreateTaskRequest {
  /**
   * 快捷交易协议号文件
   * 说明：将快捷交易协议号文件进行二进制转换，得到的二进制内容，在请求body中上传此二进制内容。只支持TXT或CSV格式的纯文本文件，每行一个加密后的协议号，换行符使用\\n，编码格式使用utf-8。使用微信支付平台证书中的公钥逐个加密协议号，并将证书序列号包含在请求HTTP头部的Wechatpay-Serial。文件大小不能超过2MB，建议单个文件的行数不超过5500行。同一个号码包的多个上传任务的文件名不可重复。
   */
  @SerializedName("file")
  private FormFile file;
  /** 文件元信息 说明：快捷协议号包的文件元信息 */
  @SerializedName("meta")
  private FileMeta meta;

  public FormFile getFile() {
    return file;
  }

  public void setFile(FormFile file) {
    this.file = file;
  }

  public FileMeta getMeta() {
    return meta;
  }

  public void setMeta(FileMeta meta) {
    this.meta = meta;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateTaskRequest {\n");
    sb.append("    file: ").append(toIndentedString(file)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
