/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.billdownload;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.service.billdownload.BillDownloadService;
import com.wechat.pay.java.service.billdownload.DigestBillEntity;
import com.wechat.pay.java.service.billdownload.model.GetFundFlowBillRequest;
import com.wechat.pay.java.service.billdownload.model.GetTradeBillRequest;
import com.wechat.pay.java.service.billdownload.model.QueryBillEntity;
import com.wechat.pay.java.service.billdownload.model.TarType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.GZIPInputStream;

public class BillDownloadServiceExtension {
    private final BillDownloadService service;
    private final HttpClient httpClient;

    private BillDownloadServiceExtension(Builder extBuilder) {
        this.service = new BillDownloadService.Builder().httpClient(extBuilder.httpClient).decryptor(extBuilder.decryptor).hostName(extBuilder.hostName).build();
        this.httpClient = extBuilder.httpClient;
    }

    public DigestBillEntity getTradeBill(GetTradeBillRequest request) {
        QueryBillEntity billEntity = this.service.getTradeBill(request);
        InputStream stream = this.getBillStream(billEntity, request.getTarType());
        return new DigestBillEntity(stream, billEntity.getHashValue(), billEntity.getHashType());
    }

    public DigestBillEntity getFundFlowBill(GetFundFlowBillRequest request) {
        QueryBillEntity billEntity = this.service.getFundFlowBill(request);
        InputStream stream = this.getBillStream(billEntity, request.getTarType());
        return new DigestBillEntity(stream, billEntity.getHashValue(), billEntity.getHashType());
    }

    private InputStream getBillStream(QueryBillEntity billEntity, TarType tarType) {
        InputStream stream = this.httpClient.download(billEntity.getDownloadUrl());
        if (tarType == TarType.GZIP) {
            try {
                stream = new GZIPInputStream(stream);
            }
            catch (IOException e) {
                throw new MalformedMessageException("invalid response", (Throwable)e);
            }
        }
        return stream;
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;
        private PrivacyDecryptor decryptor;

        public Builder config(Config config) {
            Objects.requireNonNull(config, "Config must not be null");
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            this.decryptor = config.createDecryptor();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder decryptor(PrivacyDecryptor decryptor) {
            this.decryptor = decryptor;
            return this;
        }

        public BillDownloadServiceExtension build() {
            Objects.requireNonNull(this.httpClient, "HttpClient must not be null");
            Objects.requireNonNull(this.decryptor, "Decryptor must not be null");
            return new BillDownloadServiceExtension(this);
        }
    }
}

