/*
 * Decompiled with CFR 0.152.
 */
package com.github.x25.net.tree;

import com.github.x25.net.Utils;
import com.github.x25.net.tree.radix.RadixInt32Tree;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class IpSubnetTree<V> {
    private final RadixInt32Tree<V> tree = new RadixInt32Tree();
    private volatile V defaultValue;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    private void acquireWriteLock() {
        this.readWriteLock.writeLock().lock();
    }

    private void releaseWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(V value) {
        this.defaultValue = value;
    }

    private static int getMaskByBlock(long block) {
        return block > 0L ? Integer.MIN_VALUE >> (int)(block - 1L) : 0;
    }

    private static long calcMaxBlock(long ip) {
        long mask;
        long maskedBase;
        long maxsize;
        for (maxsize = 32L; maxsize > 0L && (maskedBase = ip & (mask = (long)IpSubnetTree.getMaskByBlock(maxsize - 1L))) == ip; --maxsize) {
        }
        return maxsize;
    }

    public void insert(String cidrNotation, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        int pos = cidrNotation.indexOf(47);
        if (pos == -1) {
            this.insert(cidrNotation + "/255", value);
            return;
        }
        String ipStr = cidrNotation.substring(0, pos);
        int ip = Utils.ipAddrToInt(ipStr);
        int cidr = Integer.parseInt(cidrNotation.substring(pos + 1));
        this.acquireWriteLock();
        this.tree.insert(ip, IpSubnetTree.getMaskByBlock(cidr), value);
        this.releaseWriteLock();
    }

    public void insert(String dotDecimalRangeStart, String dotDecimalRangeEnd, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        long start = (long)Utils.ipAddrToInt(dotDecimalRangeStart) & 0xFFFFFFFFL;
        long end = (long)Utils.ipAddrToInt(dotDecimalRangeEnd) & 0xFFFFFFFFL;
        while (end >= start) {
            long maxDiff;
            long maxBlock = IpSubnetTree.calcMaxBlock(start);
            maxBlock = maxBlock > (maxDiff = (long)((int)(32.0 - Math.floor(Math.log(end - start + 1L) / Math.log(2.0))))) ? maxBlock : maxDiff;
            this.acquireWriteLock();
            this.tree.insert((int)start, IpSubnetTree.getMaskByBlock(maxBlock), value);
            this.releaseWriteLock();
            start = (long)((double)start + Math.pow(2.0, 32L - maxBlock));
        }
    }

    public V find(String dotDecimalNotation) {
        V value = this.tree.find(Utils.ipAddrToInt(dotDecimalNotation));
        return value == null ? this.defaultValue : value;
    }
}

