/*
 * Decompiled with CFR 0.152.
 */
package com.github.ywilkof.sparkrestclient;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.ywilkof.sparkrestclient.Action;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
class JobSubmitRequest {
    private Action action;
    private String appResource;
    private List<String> appArgs;
    private String clientSparkVersion;
    private String mainClass;
    private Map<String, String> environmentVariables;
    private SparkProperties sparkProperties;

    JobSubmitRequest(Action action, String appResource, List<String> appArgs, String clientSparkVersion, String mainClass, Map<String, String> environmentVariables, SparkProperties sparkProperties) {
        this.action = action;
        this.appResource = appResource;
        this.appArgs = appArgs;
        this.clientSparkVersion = clientSparkVersion;
        this.mainClass = mainClass;
        this.environmentVariables = environmentVariables;
        this.sparkProperties = sparkProperties;
    }

    public static JobSubmitRequestBuilder builder() {
        return new JobSubmitRequestBuilder();
    }

    public Action getAction() {
        return this.action;
    }

    public String getAppResource() {
        return this.appResource;
    }

    public List<String> getAppArgs() {
        return this.appArgs;
    }

    public String getClientSparkVersion() {
        return this.clientSparkVersion;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public SparkProperties getSparkProperties() {
        return this.sparkProperties;
    }

    public static class JobSubmitRequestBuilder {
        private Action action;
        private String appResource;
        private List<String> appArgs;
        private String clientSparkVersion;
        private String mainClass;
        private Map<String, String> environmentVariables;
        private SparkProperties sparkProperties;

        JobSubmitRequestBuilder() {
        }

        public JobSubmitRequestBuilder action(Action action) {
            this.action = action;
            return this;
        }

        public JobSubmitRequestBuilder appResource(String appResource) {
            this.appResource = appResource;
            return this;
        }

        public JobSubmitRequestBuilder appArgs(List<String> appArgs) {
            this.appArgs = appArgs;
            return this;
        }

        public JobSubmitRequestBuilder clientSparkVersion(String clientSparkVersion) {
            this.clientSparkVersion = clientSparkVersion;
            return this;
        }

        public JobSubmitRequestBuilder mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public JobSubmitRequestBuilder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public JobSubmitRequestBuilder sparkProperties(SparkProperties sparkProperties) {
            this.sparkProperties = sparkProperties;
            return this;
        }

        public JobSubmitRequest build() {
            return new JobSubmitRequest(this.action, this.appResource, this.appArgs, this.clientSparkVersion, this.mainClass, this.environmentVariables, this.sparkProperties);
        }

        public String toString() {
            return "JobSubmitRequest.JobSubmitRequestBuilder(action=" + (Object)((Object)this.action) + ", appResource=" + this.appResource + ", appArgs=" + this.appArgs + ", clientSparkVersion=" + this.clientSparkVersion + ", mainClass=" + this.mainClass + ", environmentVariables=" + this.environmentVariables + ", sparkProperties=" + this.sparkProperties + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    static class SparkProperties {
        @JsonProperty(value="spark.jars")
        private String jars;
        @JsonProperty(value="spark.app.name")
        private String appName;
        @JsonProperty(value="spark.master")
        private String master;
        private Map<String, String> otherProperties = new HashMap<String, String>();

        void setOtherProperties(String key, String value) {
            this.otherProperties.put(key, value);
        }

        @JsonAnyGetter
        Map<String, String> getOtherProperties() {
            return this.otherProperties;
        }

        SparkProperties(String jars, String appName, String master, Map<String, String> otherProperties) {
            this.jars = jars;
            this.appName = appName;
            this.master = master;
            this.otherProperties = otherProperties;
        }

        public static SparkPropertiesBuilder builder() {
            return new SparkPropertiesBuilder();
        }

        public static class SparkPropertiesBuilder {
            private String jars;
            private String appName;
            private String master;
            private Map<String, String> otherProperties;

            SparkPropertiesBuilder() {
            }

            public SparkPropertiesBuilder jars(String jars) {
                this.jars = jars;
                return this;
            }

            public SparkPropertiesBuilder appName(String appName) {
                this.appName = appName;
                return this;
            }

            public SparkPropertiesBuilder master(String master) {
                this.master = master;
                return this;
            }

            public SparkPropertiesBuilder otherProperties(Map<String, String> otherProperties) {
                this.otherProperties = otherProperties;
                return this;
            }

            public SparkProperties build() {
                return new SparkProperties(this.jars, this.appName, this.master, this.otherProperties);
            }

            public String toString() {
                return "JobSubmitRequest.SparkProperties.SparkPropertiesBuilder(jars=" + this.jars + ", appName=" + this.appName + ", master=" + this.master + ", otherProperties=" + this.otherProperties + ")";
            }
        }
    }
}

