/*
 * Decompiled with CFR 0.152.
 */
package com.github.ywilkof.sparkrestclient;

import com.github.ywilkof.sparkrestclient.ClusterMode;
import com.github.ywilkof.sparkrestclient.JobStatusRequestSpecificationImpl;
import com.github.ywilkof.sparkrestclient.JobSubmitRequestSpecificationImpl;
import com.github.ywilkof.sparkrestclient.KillJobRequestSpecificationImpl;
import com.github.ywilkof.sparkrestclient.interfaces.JobStatusRequestSpecification;
import com.github.ywilkof.sparkrestclient.interfaces.JobSubmitRequestSpecification;
import com.github.ywilkof.sparkrestclient.interfaces.KillJobRequestSpecification;
import com.github.ywilkof.sparkrestclient.interfaces.RequestOptionsSpecification;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class SparkRestClient
implements RequestOptionsSpecification {
    private String sparkVersion;
    private Integer masterPort;
    private String httpScheme;
    private String masterHost;
    private String masterApiRoot;
    private ClusterMode clusterMode;
    private Map<String, String> environmentVariables;
    private static final String DEPLOY_MODE_CLUSTER = "cluster";
    private HttpClient client;

    SparkRestClient() {
    }

    String getMasterUrl() {
        String host = Optional.ofNullable(this.masterHost).filter(s -> !s.isEmpty()).orElseThrow(() -> new IllegalStateException("master host must be set before getting master url"));
        Optional<String> maybeMasterApiRoot = Optional.ofNullable(this.masterApiRoot).filter(s -> !s.isEmpty());
        Optional<Integer> maybePort = Optional.ofNullable(this.masterPort);
        if (maybeMasterApiRoot.isPresent() && maybePort.isPresent()) {
            return host + ":" + this.masterPort + "/" + this.masterApiRoot;
        }
        if (!maybeMasterApiRoot.isPresent() && maybePort.isPresent()) {
            return host + ":" + this.masterPort;
        }
        if (maybeMasterApiRoot.isPresent() && !maybePort.isPresent()) {
            return host + "/" + this.masterApiRoot;
        }
        return host;
    }

    public static SparkRestClientBuilder builder() {
        return new SparkRestClientBuilder();
    }

    @Override
    public JobSubmitRequestSpecification prepareJobSubmit() {
        return new JobSubmitRequestSpecificationImpl(this);
    }

    @Override
    public KillJobRequestSpecification killJob() {
        return new KillJobRequestSpecificationImpl(this);
    }

    @Override
    public JobStatusRequestSpecification checkJobStatus() {
        return new JobStatusRequestSpecificationImpl(this);
    }

    void setSparkVersion(String sparkVersion) {
        this.sparkVersion = sparkVersion;
    }

    void setMasterPort(Integer masterPort) {
        this.masterPort = masterPort;
    }

    void setHttpScheme(String httpScheme) {
        this.httpScheme = httpScheme;
    }

    void setMasterHost(String masterHost) {
        this.masterHost = masterHost;
    }

    void setMasterApiRoot(String masterApiRoot) {
        this.masterApiRoot = masterApiRoot;
    }

    void setClusterMode(ClusterMode clusterMode) {
        this.clusterMode = clusterMode;
    }

    void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    void setClient(HttpClient client) {
        this.client = client;
    }

    public String getSparkVersion() {
        return this.sparkVersion;
    }

    public Integer getMasterPort() {
        return this.masterPort;
    }

    public String getHttpScheme() {
        return this.httpScheme;
    }

    public String getMasterHost() {
        return this.masterHost;
    }

    public String getMasterApiRoot() {
        return this.masterApiRoot;
    }

    public ClusterMode getClusterMode() {
        return this.clusterMode;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public static class SparkRestClientBuilder {
        private String sparkVersion;
        private Integer masterPort = 6066;
        private String masterHost;
        private String masterApiRoot;
        private String httpScheme = "http";
        private ClusterMode clusterMode = ClusterMode.spark;
        private Map<String, String> environmentVariables = Collections.emptyMap();
        private HttpClient client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager()).build();
        private static final Set<String> ALLOWED_HTTP_SCHEMES = new HashSet<String>(Arrays.asList("http", "https"));

        private SparkRestClientBuilder() {
        }

        public SparkRestClientBuilder sparkVersion(String sparkVersion) {
            this.sparkVersion = sparkVersion;
            return this;
        }

        public SparkRestClientBuilder masterPort(Integer masterPort) {
            this.masterPort = masterPort;
            return this;
        }

        public SparkRestClientBuilder masterApiRoot(String masterApiRoot) {
            if (masterApiRoot.startsWith("/")) {
                masterApiRoot = masterApiRoot.substring(1);
            }
            this.masterApiRoot = masterApiRoot;
            return this;
        }

        public SparkRestClientBuilder httpScheme(String httpScheme) {
            this.httpScheme = httpScheme != null ? httpScheme.toLowerCase() : null;
            return this;
        }

        public SparkRestClientBuilder masterHost(String masterHost) {
            this.masterHost = masterHost;
            return this;
        }

        public SparkRestClientBuilder clusterMode(ClusterMode clusterMode) {
            this.clusterMode = clusterMode;
            return this;
        }

        public SparkRestClientBuilder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public SparkRestClientBuilder httpClient(HttpClient httpClient) {
            this.client = httpClient;
            return this;
        }

        public SparkRestClientBuilder poolingHttpClient(int maxTotalConnections) {
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();
            poolingHttpClientConnectionManager.setMaxTotal(maxTotalConnections);
            poolingHttpClientConnectionManager.setDefaultMaxPerRoute(maxTotalConnections);
            this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).build();
            return this;
        }

        public SparkRestClient build() {
            if (this.masterHost == null) {
                throw new IllegalArgumentException("master host must be set.");
            }
            if (this.client == null) {
                throw new IllegalArgumentException("http client cannot be null.");
            }
            if (this.sparkVersion == null || this.sparkVersion.isEmpty()) {
                throw new IllegalArgumentException("spark version is not set.");
            }
            if (!ALLOWED_HTTP_SCHEMES.contains(this.httpScheme)) {
                throw new IllegalArgumentException("Supported http schemes are: [" + String.join((CharSequence)",", ALLOWED_HTTP_SCHEMES) + "]");
            }
            SparkRestClient sparkRestClient = new SparkRestClient();
            sparkRestClient.setSparkVersion(this.sparkVersion);
            sparkRestClient.setMasterPort(this.masterPort);
            sparkRestClient.setMasterHost(this.masterHost);
            sparkRestClient.setHttpScheme(this.httpScheme);
            sparkRestClient.setMasterApiRoot(this.masterApiRoot);
            sparkRestClient.setEnvironmentVariables(this.environmentVariables);
            sparkRestClient.setClient(this.client);
            sparkRestClient.setClusterMode(this.clusterMode);
            return sparkRestClient;
        }
    }
}

