/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.util.Strings;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class ByteArrayContent
extends AbstractInputStreamContent {
    private final byte[] byteArray;
    private static final byte[] EMPTY_ARRAY = new byte[0];

    public ByteArrayContent(byte[] array) {
        Preconditions.checkNotNull((Object)array);
        this.byteArray = array;
    }

    public ByteArrayContent(String contentString) {
        Preconditions.checkNotNull((Object)contentString);
        this.byteArray = Strings.toBytesUtf8(contentString);
    }

    public ByteArrayContent() {
        this.byteArray = EMPTY_ARRAY;
    }

    public long getLength() {
        return this.byteArray.length;
    }

    public boolean retrySupported() {
        return true;
    }

    protected InputStream getInputStream() {
        return new ByteArrayInputStream(this.byteArray);
    }
}

