/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import java.io.IOException;

public final class HttpRequestFactory {
    public final HttpTransport transport;
    public final HttpRequestInitializer initializer;

    HttpRequestFactory(HttpTransport transport, HttpRequestInitializer initializer) {
        this.transport = transport;
        this.initializer = initializer;
    }

    public HttpRequest buildRequest(HttpMethod method, GenericUrl url, HttpContent content) throws IOException {
        HttpRequest request = this.transport.buildRequest();
        if (this.initializer != null) {
            this.initializer.initialize(request);
        }
        request.method = method;
        request.url = url;
        request.content = content;
        return request;
    }

    public HttpRequest buildDeleteRequest(GenericUrl url) throws IOException {
        return this.buildRequest(HttpMethod.DELETE, url, null);
    }

    public HttpRequest buildGetRequest(GenericUrl url) throws IOException {
        return this.buildRequest(HttpMethod.GET, url, null);
    }

    public HttpRequest buildPostRequest(GenericUrl url, HttpContent content) throws IOException {
        return this.buildRequest(HttpMethod.POST, url, content);
    }

    public HttpRequest buildPutRequest(GenericUrl url, HttpContent content) throws IOException {
        return this.buildRequest(HttpMethod.PUT, url, content);
    }

    public HttpRequest buildPatchRequest(GenericUrl url, HttpContent content) throws IOException {
        return this.buildRequest(HttpMethod.PATCH, url, content);
    }

    public HttpRequest buildHeadRequest(GenericUrl url) throws IOException {
        return this.buildRequest(HttpMethod.HEAD, url, null);
    }
}

